/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.server.http.security.DatasourceResourceFilter;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ResourceAction;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/metadata")
public class MetadataResource {
    private final MetadataSegmentManager metadataSegmentManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public MetadataResource(MetadataSegmentManager metadataSegmentManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.metadataSegmentManager = metadataSegmentManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatabaseDataSources(@QueryParam(value="full") String full, @QueryParam(value="includeDisabled") String includeDisabled, @Context HttpServletRequest req) {
        Collection<ImmutableDruidDataSource> druidDataSources = this.metadataSegmentManager.getInventory();
        TreeSet dataSourceNamesPreAuth = includeDisabled != null ? Sets.newTreeSet(this.metadataSegmentManager.getAllDatasourceNames()) : Sets.newTreeSet((Iterable)Iterables.transform(druidDataSources, ImmutableDruidDataSource::getName));
        TreeSet dataSourceNamesPostAuth = Sets.newTreeSet();
        Function raGenerator = datasourceName -> Lists.newArrayList((Object[])new ResourceAction[]{(ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasourceName)});
        Iterables.addAll((Collection)dataSourceNamesPostAuth, AuthorizationUtils.filterAuthorizedResources(req, dataSourceNamesPreAuth, raGenerator, this.authorizerMapper));
        if (full != null && includeDisabled == null) {
            return Response.ok().entity((Object)Collections2.filter(druidDataSources, dataSource -> dataSourceNamesPostAuth.contains(dataSource.getName()))).build();
        }
        return Response.ok().entity((Object)dataSourceNamesPostAuth).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, String>(){

            public String apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full, List<Interval> intervals) {
        List<DataSegment> segments;
        try {
            segments = this.metadataStorageCoordinator.getUsedSegmentsForIntervals(dataSourceName, intervals);
        }
        catch (IOException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(segments).build();
        }
        return builder.entity((Object)Iterables.transform(segments, (Function)new Function<DataSegment, String>(){

            public String apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

