/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.inject.Inject;
import io.druid.client.selector.Server;
import io.druid.server.router.TieredBrokerHostSelector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/druid/router/v1")
public class RouterResource {
    private final TieredBrokerHostSelector tieredBrokerHostSelector;

    @Inject
    public RouterResource(TieredBrokerHostSelector tieredBrokerHostSelector) {
        this.tieredBrokerHostSelector = tieredBrokerHostSelector;
    }

    @GET
    @Path(value="/brokers")
    @Produces(value={"application/json"})
    public Map<String, List<String>> getBrokers() {
        Map<String, List<Server>> brokerSelectorMap = this.tieredBrokerHostSelector.getAllBrokers();
        HashMap<String, List<String>> brokersMap = new HashMap<String, List<String>>(brokerSelectorMap.size());
        for (Map.Entry<String, List<Server>> e : brokerSelectorMap.entrySet()) {
            brokersMap.put(e.getKey(), e.getValue().stream().map(s -> s.getHost()).collect(Collectors.toList()));
        }
        return brokersMap;
    }
}

