/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordination.BatchDataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.SegmentChangeRequestHistory;
import io.druid.server.coordination.SegmentChangeRequestsSnapshot;
import io.druid.server.coordination.SegmentLoadDropHandler;
import io.druid.server.coordinator.HttpLoadQueuePeon;
import io.druid.server.http.security.StateResourceFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Path(value="/druid-internal/v1/segments/")
@ResourceFilters(value={StateResourceFilter.class})
public class SegmentListerResource {
    protected static final EmittingLogger log = new EmittingLogger(SegmentListerResource.class);
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    private final BatchDataSegmentAnnouncer announcer;
    private final SegmentLoadDropHandler loadDropRequestHandler;

    @Inject
    public SegmentListerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @Nullable BatchDataSegmentAnnouncer announcer, @Nullable SegmentLoadDropHandler loadDropRequestHandler) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.announcer = announcer;
        this.loadDropRequestHandler = loadDropRequestHandler;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public void getSegments(@QueryParam(value="counter") long counter, @QueryParam(value="hash") long hash, @QueryParam(value="timeout") long timeout, @Context HttpServletRequest req) throws IOException {
        if (this.announcer == null) {
            this.sendErrorResponse(req, 404, "announcer is not available.");
            return;
        }
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<SegmentChangeRequestsSnapshot> future = this.announcer.getSegmentChangesSince(new SegmentChangeRequestHistory.Counter(counter, hash));
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
        Futures.addCallback(future, (FutureCallback)new FutureCallback<SegmentChangeRequestsSnapshot>(){

            public void onSuccess(SegmentChangeRequestsSnapshot result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), (Object)result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
    }

    @POST
    @Path(value="/changeRequests")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public void applyDataSegmentChangeRequests(@QueryParam(value="timeout") long timeout, List<DataSegmentChangeRequest> changeRequestList, @Context HttpServletRequest req) throws IOException {
        if (this.loadDropRequestHandler == null) {
            this.sendErrorResponse(req, 404, "load/drop handler is not available.");
            return;
        }
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return;
        }
        if (changeRequestList == null || changeRequestList.isEmpty()) {
            this.sendErrorResponse(req, 400, "No change requests provided.");
            return;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>> future = this.loadDropRequestHandler.processBatch(changeRequestList);
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
        Futures.addCallback(future, (FutureCallback)new FutureCallback<List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>>(){

            public void onSuccess(List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus> result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writerWithType(HttpLoadQueuePeon.RESPONSE_ENTITY_TYPE_REF).writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
    }

    private void sendErrorResponse(HttpServletRequest req, int code, String error) throws IOException {
        AsyncContext asyncContext = req.startAsync();
        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        response.sendError(code, error);
        asyncContext.complete();
    }

    private ResponseContext createContext(String requestType) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType);
        return new ResponseContext(isSmile ? this.smileMapper : this.jsonMapper);
    }

    private static class ResponseContext {
        private final ObjectMapper inputMapper;

        ResponseContext(ObjectMapper inputMapper) {
            this.inputMapper = inputMapper;
        }
    }
}

