/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import io.druid.server.http.security.AbstractResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ForbiddenException;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceAction;
import io.druid.server.security.ResourceType;
import javax.ws.rs.core.PathSegment;

public class DatasourceResourceFilter
extends AbstractResourceFilter {
    @Inject
    public DatasourceResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource(this.getRequestDatasourceName(request), ResourceType.DATASOURCE), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    private String getRequestDatasourceName(ContainerRequest request) {
        String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

            public boolean apply(PathSegment input) {
                return input.getPath().equals("datasources");
            }
        }) + 1)).getPath();
        Preconditions.checkNotNull((Object)dataSourceName);
        return dataSourceName;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        ImmutableList applicablePaths = ImmutableList.of((Object)"druid/coordinator/v1/datasources/", (Object)"druid/coordinator/v1/metadata/datasources/", (Object)"druid/v2/datasources/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

