/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.JsonConfigurator;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.initialization.DruidModule;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.security.AllowAllAuthorizer;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.Authorizer;
import io.druid.server.security.AuthorizerMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AuthorizerMapperModule
implements DruidModule {
    private static final String AUTHORIZER_PROPERTIES_FORMAT_STRING = "druid.auth.authorizer.%s";
    private static Logger log = new Logger(AuthorizerMapperModule.class);

    public void configure(Binder binder) {
        binder.bind(AuthorizerMapper.class).toProvider((Provider)new AuthorizerMapperProvider()).in(LazySingleton.class);
        LifecycleModule.register((Binder)binder, AuthorizerMapper.class);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.EMPTY_LIST;
    }

    private static void validateAuthorizers(List<String> authorizers) {
        if (authorizers == null) {
            return;
        }
        if (authorizers.isEmpty()) {
            throw new IAE("Must have at least one Authorizer configured.", new Object[0]);
        }
        HashSet<String> authorizerSet = new HashSet<String>();
        for (String authorizer : authorizers) {
            if (authorizerSet.contains(authorizer)) {
                throw new ISE("Cannot have multiple authorizers with the same name: [%s]", new Object[]{authorizer});
            }
            authorizerSet.add(authorizer);
        }
    }

    private static class AuthorizerMapperProvider
    implements Provider<AuthorizerMapper> {
        private AuthConfig authConfig;
        private Injector injector;
        private Properties props;
        private JsonConfigurator configurator;

        private AuthorizerMapperProvider() {
        }

        @Inject
        public void inject(Injector injector, Properties props, JsonConfigurator configurator) {
            this.authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
            this.injector = injector;
            this.props = props;
            this.configurator = configurator;
        }

        public AuthorizerMapper get() {
            final HashMap authorizerMap = Maps.newHashMap();
            List<String> authorizers = this.authConfig.getAuthorizers();
            AuthorizerMapperModule.validateAuthorizers(authorizers);
            if (authorizers == null) {
                final AllowAllAuthorizer allowAllAuthorizer = new AllowAllAuthorizer();
                authorizerMap.put("allowAll", allowAllAuthorizer);
                return new AuthorizerMapper(null){

                    @Override
                    public Authorizer getAuthorizer(String name) {
                        return allowAllAuthorizer;
                    }

                    @Override
                    public Map<String, Authorizer> getAuthorizerMap() {
                        return authorizerMap;
                    }
                };
            }
            for (String authorizerName : authorizers) {
                String authorizerPropertyBase = StringUtils.format((String)AuthorizerMapperModule.AUTHORIZER_PROPERTIES_FORMAT_STRING, (Object[])new Object[]{authorizerName});
                JsonConfigProvider authorizerProvider = new JsonConfigProvider(authorizerPropertyBase, Authorizer.class);
                Properties adjustedProps = new Properties(this.props);
                String nameProperty = StringUtils.format((String)"druid.auth.authorizer.%s.name", (Object[])new Object[]{authorizerName});
                if (adjustedProps.containsKey(nameProperty)) {
                    throw new IAE("Name property [%s] is reserved.", new Object[]{nameProperty});
                }
                adjustedProps.put(nameProperty, authorizerName);
                authorizerProvider.inject(adjustedProps, this.configurator);
                Supplier authorizerSupplier = authorizerProvider.get();
                if (authorizerSupplier == null) {
                    throw new ISE("Could not create authorizer with name: %s", new Object[]{authorizerName});
                }
                Authorizer authorizer = (Authorizer)authorizerSupplier.get();
                authorizerMap.put(authorizerName, authorizer);
            }
            return new AuthorizerMapper(authorizerMap);
        }
    }
}

