/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization.jetty;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.annotations.RemoteChatHandler;
import io.druid.guice.annotations.Self;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.realtime.firehose.ChatHandlerResource;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ServerConfig;
import io.druid.server.initialization.TLSServerConfig;
import io.druid.server.initialization.jetty.JettyBindings;
import io.druid.server.initialization.jetty.JettyServerModule;
import io.druid.server.initialization.jetty.ServletFilterHolder;
import io.druid.server.initialization.jetty.TaskIdResponseHeaderFilterHolder;
import io.druid.server.metrics.DataSourceTaskIdHolder;
import java.util.Properties;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ChatHandlerServerModule
implements Module {
    private static final Logger log = new Logger(ChatHandlerServerModule.class);
    private static final String MAX_CHAT_REQUESTS_PROPERTY = "druid.indexer.server.maxChatRequests";
    private static final String CHAT_PORT_PROPERTY = "druid.indexer.task.chathandler.port";
    private final Properties properties;

    public ChatHandlerServerModule(Properties properties) {
        this.properties = properties;
    }

    public void configure(Binder binder) {
        Jerseys.addResource((Binder)binder, ChatHandlerResource.class);
        LifecycleModule.register((Binder)binder, ChatHandlerResource.class);
        if (this.properties.containsKey(MAX_CHAT_REQUESTS_PROPERTY)) {
            int maxRequests = Integer.parseInt(this.properties.getProperty(MAX_CHAT_REQUESTS_PROPERTY));
            JettyBindings.addQosFilter(binder, "/druid/worker/v1/chat/*", maxRequests);
        }
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class).addBinding().to(TaskIdResponseHeaderFilterHolder.class);
        if (this.properties.containsKey(CHAT_PORT_PROPERTY)) {
            log.info("Spawning separate ingestion server at port [%s]", new Object[]{this.properties.getProperty(CHAT_PORT_PROPERTY)});
            JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task.chathandler", DruidNode.class, RemoteChatHandler.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.server.chathandler.http", ServerConfig.class, RemoteChatHandler.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.server.chathandler.https", TLSServerConfig.class, RemoteChatHandler.class);
            LifecycleModule.register((Binder)binder, Server.class, RemoteChatHandler.class);
        } else {
            binder.bind(DruidNode.class).annotatedWith(RemoteChatHandler.class).to(Key.get(DruidNode.class, Self.class));
            binder.bind(ServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(ServerConfig.class));
            binder.bind(TLSServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(TLSServerConfig.class));
        }
    }

    @Provides
    @LazySingleton
    public TaskIdResponseHeaderFilterHolder taskIdResponseHeaderFilterHolderBuilder(DataSourceTaskIdHolder taskIdHolder) {
        return new TaskIdResponseHeaderFilterHolder("/druid/worker/v1/chat/*", taskIdHolder.getTaskId());
    }

    @Provides
    @LazySingleton
    @RemoteChatHandler
    public Server getServer(Injector injector, Lifecycle lifecycle, @RemoteChatHandler DruidNode node, @RemoteChatHandler ServerConfig config, @RemoteChatHandler TLSServerConfig TLSServerConfig2) {
        return JettyServerModule.makeAndInitializeServer(injector, lifecycle, node, config, TLSServerConfig2, (Binding<SslContextFactory>)injector.getExistingBinding(Key.get(SslContextFactory.class)));
    }
}

