/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.java.util.metrics.AbstractMonitor;
import io.druid.java.util.metrics.KeyedDiff;
import io.druid.java.util.metrics.MonitorUtils;
import io.druid.server.metrics.EventReceiverFirehoseMetric;
import io.druid.server.metrics.EventReceiverFirehoseRegister;
import io.druid.server.metrics.MonitorsConfig;
import java.util.Map;
import java.util.Properties;

public class EventReceiverFirehoseMonitor
extends AbstractMonitor {
    private final EventReceiverFirehoseRegister register;
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final Map<String, String[]> dimensions;

    @Inject
    public EventReceiverFirehoseMonitor(EventReceiverFirehoseRegister eventReceiverFirehoseRegister, Properties props) {
        this.register = eventReceiverFirehoseRegister;
        this.dimensions = MonitorsConfig.extractDimensions(props, Lists.newArrayList((Object[])new String[]{"dataSource", "taskId"}));
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (Map.Entry<String, EventReceiverFirehoseMetric> entry : this.register.getMetrics()) {
            String serviceName = entry.getKey();
            EventReceiverFirehoseMetric metric = entry.getValue();
            ServiceMetricEvent.Builder builder = this.createEventBuilder(serviceName).setDimension("bufferCapacity", String.valueOf(metric.getCapacity()));
            emitter.emit(builder.build("ingest/events/buffered", (Number)metric.getCurrentBufferSize()));
            Map diff = this.keyedDiff.to(serviceName, (Map)ImmutableMap.of((Object)"ingest/bytes/received", (Object)metric.getBytesReceived()));
            if (diff == null) continue;
            ServiceMetricEvent.Builder eventBuilder = this.createEventBuilder(serviceName);
            for (Map.Entry diffEntry : diff.entrySet()) {
                emitter.emit(eventBuilder.build((String)diffEntry.getKey(), (Number)diffEntry.getValue()));
            }
        }
        return true;
    }

    private ServiceMetricEvent.Builder createEventBuilder(String serviceName) {
        ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder().setDimension("serviceName", serviceName);
        MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
        return builder;
    }
}

