/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.server.security.AuthenticationWrappingFilter;
import io.druid.server.security.Authenticator;
import io.druid.server.security.PreResponseAuthorizationCheckFilter;
import io.druid.server.security.SecuritySanityCheckFilter;
import io.druid.server.security.UnsecuredResourceFilter;
import java.util.List;
import javax.servlet.Filter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class AuthenticationUtils {
    public static void addAuthenticationFilterChain(ServletContextHandler root, List<Authenticator> authenticators) {
        for (Authenticator authenticator : authenticators) {
            FilterHolder holder = new FilterHolder((Filter)new AuthenticationWrappingFilter(authenticator.getFilter()));
            if (authenticator.getInitParameters() != null) {
                holder.setInitParameters(authenticator.getInitParameters());
            }
            root.addFilter(holder, "/*", null);
        }
    }

    public static void addNoopAuthorizationFilters(ServletContextHandler root, List<String> unsecuredPaths) {
        for (String unsecuredPath : unsecuredPaths) {
            root.addFilter(new FilterHolder((Filter)new UnsecuredResourceFilter()), unsecuredPath, null);
        }
    }

    public static void addSecuritySanityCheckFilter(ServletContextHandler root, ObjectMapper jsonMapper) {
        root.addFilter(new FilterHolder((Filter)new SecuritySanityCheckFilter(jsonMapper)), "/*", null);
    }

    public static void addPreResponseAuthorizationCheckFilter(ServletContextHandler root, List<Authenticator> authenticators, ObjectMapper jsonMapper) {
        root.addFilter(new FilterHolder((Filter)new PreResponseAuthorizationCheckFilter(authenticators, jsonMapper)), "/*", null);
    }
}

