/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.curator.discovery.CuratorServiceUtils;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.server.DruidNode;
import java.util.Map;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;

public class CuratorServiceAnnouncer
implements ServiceAnnouncer {
    private static final EmittingLogger log = new EmittingLogger(CuratorServiceAnnouncer.class);
    private final ServiceDiscovery<Void> discovery;
    private final Map<String, ServiceInstance<Void>> instanceMap = Maps.newHashMap();
    private final Object monitor = new Object();

    @Inject
    public CuratorServiceAnnouncer(ServiceDiscovery<Void> discovery) {
        this.discovery = discovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce(DruidNode service) {
        ServiceInstance instance;
        String serviceName = CuratorServiceUtils.makeCanonicalServiceName(service.getServiceName());
        Object object = this.monitor;
        synchronized (object) {
            if (this.instanceMap.containsKey(serviceName)) {
                log.warn("Ignoring request to announce service[%s]", new Object[]{service});
                return;
            }
            try {
                instance = ServiceInstance.builder().name(serviceName).address(service.getHost()).port(service.getPort()).build();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.instanceMap.put(serviceName, (ServiceInstance<Void>)instance);
        }
        try {
            log.info("Announcing service[%s]", new Object[]{service});
            this.discovery.registerService(instance);
        }
        catch (Exception e) {
            log.warn("Failed to announce service[%s]", new Object[]{service});
            Object object2 = this.monitor;
            synchronized (object2) {
                this.instanceMap.remove(serviceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounce(DruidNode service) {
        ServiceInstance<Void> instance;
        String serviceName = CuratorServiceUtils.makeCanonicalServiceName(service.getServiceName());
        Object object = this.monitor;
        synchronized (object) {
            instance = this.instanceMap.get(serviceName);
            if (instance == null) {
                log.warn("Ignoring request to unannounce service[%s]", new Object[]{service});
                return;
            }
        }
        log.info("Unannouncing service[%s]", new Object[]{service});
        try {
            this.discovery.unregisterService(instance);
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Failed to unannounce service[%s], zombie znode perhaps in existence.", new Object[]{serviceName}).addData("service", (Object)service).emit();
        }
        finally {
            Object object2 = this.monitor;
            synchronized (object2) {
                this.instanceMap.remove(serviceName);
            }
        }
    }
}

