/*
 * Decompiled with CFR 0.152.
 */
package io.druid.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.curator.CuratorModule;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.guice.AWSModule;
import io.druid.guice.AnnouncerModule;
import io.druid.guice.CoordinatorDiscoveryModule;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.FirehoseModule;
import io.druid.guice.IndexingServiceDiscoveryModule;
import io.druid.guice.JacksonConfigManagerModule;
import io.druid.guice.JavaScriptModule;
import io.druid.guice.LifecycleModule;
import io.druid.guice.LocalDataStorageDruidModule;
import io.druid.guice.MetadataConfigModule;
import io.druid.guice.ParsersModule;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.ServerModule;
import io.druid.guice.ServerViewModule;
import io.druid.guice.StartupLoggingModule;
import io.druid.guice.StorageNodeModule;
import io.druid.guice.annotations.Client;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.guice.http.HttpClientModule;
import io.druid.guice.security.DruidAuthModule;
import io.druid.initialization.DruidModule;
import io.druid.initialization.Log4jShutterDownerModule;
import io.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import io.druid.server.initialization.EmitterModule;
import io.druid.server.initialization.jetty.JettyServerModule;
import io.druid.server.metrics.MetricsModule;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final ConcurrentMap<File, URLClassLoader> loadersMap = new ConcurrentHashMap<File, URLClassLoader>();
    private static final Map<Class, Set> extensionsMap = Maps.newHashMap();

    public static <T> Set<T> getLoadedModules(Class<T> clazz) {
        Set retVal = extensionsMap.get(clazz);
        if (retVal == null) {
            return Sets.newHashSet();
        }
        return retVal;
    }

    @VisibleForTesting
    static void clearLoadedModules() {
        extensionsMap.clear();
    }

    @VisibleForTesting
    static Map<File, URLClassLoader> getLoadersMap() {
        return loadersMap;
    }

    public static synchronized <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> clazz) {
        HashSet retVal = Sets.newHashSet();
        HashSet loadedExtensionNames = Sets.newHashSet();
        if (config.searchCurrentClassloader()) {
            for (Object module : ServiceLoader.load(clazz, Thread.currentThread().getContextClassLoader())) {
                String moduleName = module.getClass().getCanonicalName();
                if (moduleName == null) {
                    log.warn("Extension module [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{module.getClass().getName()});
                    continue;
                }
                if (loadedExtensionNames.contains(moduleName)) continue;
                log.info("Adding classpath extension module [%s] for class [%s]", new Object[]{moduleName, clazz.getName()});
                loadedExtensionNames.add(moduleName);
                retVal.add(module);
            }
        }
        for (File extension : Initialization.getExtensionFilesToLoad(config)) {
            log.info("Loading extension [%s] for class [%s]", new Object[]{extension.getName(), clazz.getName()});
            try {
                URLClassLoader loader = Initialization.getClassLoaderForExtension(extension);
                for (T module : ServiceLoader.load(clazz, loader)) {
                    String moduleName = module.getClass().getCanonicalName();
                    if (moduleName == null) {
                        log.warn("Extension module [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{module.getClass().getName()});
                        continue;
                    }
                    if (loadedExtensionNames.contains(moduleName)) continue;
                    log.info("Adding local file system extension module [%s] for class [%s]", new Object[]{moduleName, clazz.getName()});
                    loadedExtensionNames.add(moduleName);
                    retVal.add(module);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        extensionsMap.put(clazz, retVal);
        return retVal;
    }

    public static File[] getExtensionFilesToLoad(ExtensionsConfig config) {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(config.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", new Object[]{rootExtensionsDir});
        }
        List toLoad = config.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(rootExtensionsDir, extensionName);
                if (!extensionDir.isDirectory()) {
                    throw new ISE(String.format("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", extensionDir.getAbsolutePath()), new Object[0]);
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public static File[] getHadoopDependencyFilesToLoad(List<String> hadoopDependencyCoordinates, ExtensionsConfig extensionsConfig) {
        File rootHadoopDependenciesDir = new File(extensionsConfig.getHadoopDependenciesDir());
        if (rootHadoopDependenciesDir.exists() && !rootHadoopDependenciesDir.isDirectory()) {
            throw new ISE("Root Hadoop dependencies directory [%s] is not a directory!?", new Object[]{rootHadoopDependenciesDir});
        }
        File[] hadoopDependenciesToLoad = new File[hadoopDependencyCoordinates.size()];
        int i = 0;
        for (String coordinate : hadoopDependencyCoordinates) {
            DefaultArtifact artifact = new DefaultArtifact(coordinate);
            File hadoopDependencyDir = new File(rootHadoopDependenciesDir, artifact.getArtifactId());
            File versionDir = new File(hadoopDependencyDir, artifact.getVersion());
            if (!hadoopDependencyDir.isDirectory() || !versionDir.isDirectory()) {
                throw new ISE(String.format("Hadoop dependency [%s] didn't exist!?", versionDir.getAbsolutePath()), new Object[0]);
            }
            hadoopDependenciesToLoad[i++] = versionDir;
        }
        return hadoopDependenciesToLoad;
    }

    public static URLClassLoader getClassLoaderForExtension(File extension) throws MalformedURLException {
        URLClassLoader loader = (URLClassLoader)loadersMap.get(extension);
        if (loader == null) {
            Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
            URL[] urls = new URL[jars.size()];
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.info("added URL[%s]", new Object[]{url});
                urls[i++] = url;
            }
            loadersMap.putIfAbsent(extension, new URLClassLoader(urls, Initialization.class.getClassLoader()));
            loader = (URLClassLoader)loadersMap.get(extension);
        }
        return loader;
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(paths[i]).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<? extends Module> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector);
        defaultModules.addModules(new Object[]{new Log4jShutterDownerModule(), new DruidAuthModule(), new LifecycleModule(), EmitterModule.class, HttpClientModule.global(), new HttpClientModule("druid.broker.http", Client.class), new CuratorModule(), new AnnouncerModule(), new DruidProcessingModule(), new AWSModule(), new MetricsModule(), new ServerModule(), new StorageNodeModule(), new JettyServerModule(), new QueryableModule(), new QueryRunnerFactoryModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new IndexingServiceDiscoveryModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new FirehoseModule(), new ParsersModule(), new JavaScriptModule(), new StartupLoggingModule()});
        ModuleList actualModules = new ModuleList(baseInjector);
        actualModules.addModule(DruidSecondaryModule.class);
        for (Module module : modules) {
            actualModules.addModule(module);
        }
        Module intermediateModules = Modules.override((Iterable)defaultModules.getModules()).with((Iterable)actualModules.getModules());
        ModuleList moduleList = new ModuleList(baseInjector);
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (DruidModule module : Initialization.getFromExtensions(config, DruidModule.class)) {
            moduleList.addModule(module);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{intermediateModules}).with((Iterable)moduleList.getModules())});
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final ObjectMapper jsonMapper;
        private final ObjectMapper smileMapper;
        private final List<Module> modules;

        public ModuleList(Injector baseInjector) {
            this.baseInjector = baseInjector;
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
            this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
            this.modules = Lists.newArrayList();
        }

        private List<Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (input instanceof DruidModule) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)this.registerJacksonModules((DruidModule)input));
                return;
            } else if (input instanceof Module) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
                if (DruidModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add((Module)this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                    return;
                } else {
                    if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                    this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private DruidModule registerJacksonModules(DruidModule module) {
            for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
                this.jsonMapper.registerModule(jacksonModule);
                this.smileMapper.registerModule(jacksonModule);
            }
            return module;
        }
    }
}

