/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.metamx.common.Granularity;
import com.metamx.common.guava.Comparators;
import io.druid.granularity.QueryGranularity;
import io.druid.segment.indexing.granularity.GranularitySpec;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ArbitraryGranularitySpec
implements GranularitySpec {
    private final TreeSet<Interval> intervals;
    private final QueryGranularity queryGranularity;
    private final Boolean rollup;

    @JsonCreator
    public ArbitraryGranularitySpec(@JsonProperty(value="queryGranularity") QueryGranularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        this.queryGranularity = queryGranularity;
        this.rollup = rollup == null ? Boolean.TRUE : rollup;
        this.intervals = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        if (inputIntervals == null) {
            inputIntervals = Lists.newArrayList();
        }
        for (Interval inputInterval : inputIntervals) {
            this.intervals.add(inputInterval);
        }
        PeekingIterator intervalIterator = Iterators.peekingIterator(this.intervals.iterator());
        while (intervalIterator.hasNext()) {
            Interval nextInterval;
            Interval currentInterval = (Interval)intervalIterator.next();
            if (!intervalIterator.hasNext() || !currentInterval.overlaps((ReadableInterval)(nextInterval = (Interval)intervalIterator.peek()))) continue;
            throw new IllegalArgumentException(String.format("Overlapping intervals: %s, %s", currentInterval, nextInterval));
        }
    }

    public ArbitraryGranularitySpec(QueryGranularity queryGranularity, List<Interval> inputIntervals) {
        this(queryGranularity, true, inputIntervals);
    }

    @Override
    @JsonProperty(value="intervals")
    public Optional<SortedSet<Interval>> bucketIntervals() {
        return Optional.of(this.intervals);
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        Interval interval = this.intervals.floor(new Interval((ReadableInstant)dt, (ReadableInstant)new DateTime(0x3FFFFFFFFFFFFFFFL)));
        if (interval != null && interval.contains((ReadableInstant)dt)) {
            return Optional.of((Object)interval);
        }
        return Optional.absent();
    }

    @Override
    public Granularity getSegmentGranularity() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="rollup")
    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public QueryGranularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArbitraryGranularitySpec that = (ArbitraryGranularitySpec)o;
        if (!this.intervals.equals(that.intervals)) {
            return false;
        }
        if (!this.rollup.equals(that.rollup)) {
            return false;
        }
        return !(this.queryGranularity == null ? that.queryGranularity != null : !this.queryGranularity.equals(that.queryGranularity));
    }

    public int hashCode() {
        int result = this.intervals.hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.queryGranularity != null ? this.queryGranularity.hashCode() : 0);
        return result;
    }
}

