/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.collect.Sets;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.util.Set;

class StorageLocation {
    private final File path;
    private final long maxSize;
    private final Set<DataSegment> segments;
    private volatile long currSize = 0L;

    StorageLocation(File path, long maxSize) {
        this.path = path;
        this.maxSize = maxSize;
        this.segments = Sets.newHashSet();
    }

    File getPath() {
        return this.path;
    }

    long getMaxSize() {
        return this.maxSize;
    }

    synchronized void addSegment(DataSegment segment) {
        if (this.segments.add(segment)) {
            this.currSize += segment.getSize();
        }
    }

    synchronized void removeSegment(DataSegment segment) {
        if (this.segments.remove(segment)) {
            this.currSize -= segment.getSize();
        }
    }

    boolean canHandle(long size) {
        return this.available() >= size;
    }

    synchronized long available() {
        return this.maxSize - this.currSize;
    }

    StorageLocation mostEmpty(StorageLocation other) {
        return this.available() > other.available() ? this : other;
    }
}

