/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class TimedShutoffFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(FirehoseFactory.class);
    private final FirehoseFactory delegateFactory;
    private final DateTime shutoffTime;

    @JsonCreator
    public TimedShutoffFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegateFactory, @JsonProperty(value="shutoffTime") DateTime shutoffTime) {
        this.delegateFactory = delegateFactory;
        this.shutoffTime = shutoffTime;
    }

    public Firehose connect(InputRowParser parser) throws IOException {
        return new TimedShutoffFirehose(parser);
    }

    @JsonProperty(value="delegate")
    public FirehoseFactory getDelegateFactory() {
        return this.delegateFactory;
    }

    @JsonProperty(value="shutoffTime")
    public DateTime getShutoffTime() {
        return this.shutoffTime;
    }

    public class TimedShutoffFirehose
    implements Firehose {
        private final Firehose firehose;
        private final ScheduledExecutorService exec;
        private final Object shutdownLock = new Object();
        private volatile boolean shutdown = false;

        public TimedShutoffFirehose(InputRowParser parser) throws IOException {
            this.firehose = TimedShutoffFirehoseFactory.this.delegateFactory.connect(parser);
            this.exec = Execs.scheduledSingleThreaded((String)"timed-shutoff-firehose-%d");
            this.exec.schedule(new Runnable(){

                @Override
                public void run() {
                    log.info("Closing delegate firehose.", new Object[0]);
                    TimedShutoffFirehose.this.shutdown = true;
                    try {
                        TimedShutoffFirehose.this.firehose.close();
                    }
                    catch (IOException e) {
                        log.warn((Throwable)e, "Failed to close delegate firehose, ignoring.", new Object[0]);
                    }
                }
            }, TimedShutoffFirehoseFactory.this.shutoffTime.getMillis() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            log.info("Firehose created, will shut down at: %s", new Object[]{TimedShutoffFirehoseFactory.this.shutoffTime});
        }

        public boolean hasMore() {
            return this.firehose.hasMore();
        }

        public InputRow nextRow() {
            return this.firehose.nextRow();
        }

        public Runnable commit() {
            return this.firehose.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.shutdownLock;
            synchronized (object) {
                if (!this.shutdown) {
                    this.shutdown = true;
                    this.firehose.close();
                }
            }
        }
    }
}

