/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.client.ServerViewUtil;
import io.druid.client.TimelineServerView;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.Query;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.server.QueryManager;
import io.druid.server.QueryResource;
import io.druid.server.http.security.StateResourceFilter;
import io.druid.server.initialization.ServerConfig;
import io.druid.server.log.RequestLogger;
import io.druid.server.security.AuthConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;

@Path(value="/druid/v2/")
public class BrokerQueryResource
extends QueryResource {
    private final TimelineServerView brokerServerView;

    @Inject
    public BrokerQueryResource(QueryToolChestWarehouse warehouse, ServerConfig config, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QuerySegmentWalker texasRanger, ServiceEmitter emitter, RequestLogger requestLogger, QueryManager queryManager, AuthConfig authConfig, TimelineServerView brokerServerView) {
        super(warehouse, config, jsonMapper, smileMapper, texasRanger, emitter, requestLogger, queryManager, authConfig);
        this.brokerServerView = brokerServerView;
    }

    @POST
    @Path(value="/candidates")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getQueryTargets(InputStream in, @QueryParam(value="pretty") String pretty, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @Context HttpServletRequest req) throws IOException {
        QueryResource.ResponseContext context = this.createContext(req.getContentType(), pretty != null);
        try {
            Query query = (Query)context.getObjectMapper().readValue(in, Query.class);
            return context.ok(ServerViewUtil.getTargetLocations(this.brokerServerView, query.getDataSource(), (List<Interval>)query.getIntervals(), numCandidates));
        }
        catch (Exception e) {
            return context.gotError(e);
        }
    }
}

