/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.audit.AuditManager;
import io.druid.guice.annotations.Json;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.server.audit.AuditManagerProvider;
import io.druid.server.audit.SQLAuditManager;
import io.druid.server.audit.SQLAuditManagerConfig;

public class SQLAuditManagerProvider
implements AuditManagerProvider {
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;
    private final ServiceEmitter emitter;
    private final ObjectMapper mapper;
    private final SQLAuditManagerConfig config;

    @Inject
    public SQLAuditManagerProvider(Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector, Lifecycle lifecycle, ServiceEmitter emitter, @Json ObjectMapper mapper, SQLAuditManagerConfig config) {
        this.dbTables = dbTables;
        this.connector = connector;
        this.lifecycle = lifecycle;
        this.emitter = emitter;
        this.mapper = mapper;
        this.config = config;
    }

    @Override
    public AuditManager get() {
        try {
            this.lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() throws Exception {
                    SQLAuditManagerProvider.this.connector.createAuditTable();
                }

                public void stop() {
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return new SQLAuditManager(this.connector, this.dbTables, this.emitter, this.mapper, this.config);
    }
}

