/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.CachingQueryRunner;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.collections.CountingMap;
import io.druid.guice.annotations.BackgroundCaching;
import io.druid.guice.annotations.Processing;
import io.druid.guice.annotations.Smile;
import io.druid.query.BySegmentQueryRunner;
import io.druid.query.CPUTimeMetricQueryRunner;
import io.druid.query.DataSource;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.ReferenceCountingSegmentQueryRunner;
import io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import io.druid.query.SegmentDescriptor;
import io.druid.query.TableDataSource;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.ReferenceCountingSegment;
import io.druid.segment.Segment;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final Object lock = new Object();
    private final SegmentLoader segmentLoader;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final ExecutorService cachingExec;
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> dataSources;
    private final CountingMap<String> dataSourceSizes = new CountingMap();
    private final CountingMap<String> dataSourceCounts = new CountingMap();
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;

    @Inject
    public ServerManager(SegmentLoader segmentLoader, QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, @BackgroundCaching ExecutorService cachingExec, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig) {
        this.segmentLoader = segmentLoader;
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachingExec = cachingExec;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.dataSources = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
        this.cacheConfig = cacheConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceSizes() {
        CountingMap<String> countingMap = this.dataSourceSizes;
        synchronized (countingMap) {
            return this.dataSourceSizes.snapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceCounts() {
        CountingMap<String> countingMap = this.dataSourceCounts;
        synchronized (countingMap) {
            return this.dataSourceCounts.snapshot();
        }
    }

    public boolean isSegmentCached(DataSegment segment) throws SegmentLoadingException {
        return this.segmentLoader.isSegmentLoaded(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSegment(DataSegment segment) throws SegmentLoadingException {
        Segment adapter;
        try {
            adapter = this.segmentLoader.getSegment(segment);
        }
        catch (SegmentLoadingException e) {
            try {
                this.segmentLoader.cleanup(segment);
            }
            catch (SegmentLoadingException segmentLoadingException) {
                // empty catch block
            }
            throw e;
        }
        if (adapter == null) {
            throw new SegmentLoadingException("Null adapter from loadSpec[%s]", new Object[]{segment.getLoadSpec()});
        }
        Object object = this.lock;
        synchronized (object) {
            PartitionHolder entry;
            String dataSource = segment.getDataSource();
            VersionedIntervalTimeline loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                loadedIntervals = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                this.dataSources.put(dataSource, (VersionedIntervalTimeline<String, ReferenceCountingSegment>)loadedIntervals);
            }
            if ((entry = loadedIntervals.findEntry(segment.getInterval(), (Object)segment.getVersion())) != null && entry.getChunk(segment.getShardSpec().getPartitionNum()) != null) {
                log.warn("Told to load a adapter for a segment[%s] that already exists", new Object[]{segment.getIdentifier()});
                return false;
            }
            loadedIntervals.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)new ReferenceCountingSegment(adapter)));
            CountingMap<String> countingMap = this.dataSourceSizes;
            synchronized (countingMap) {
                this.dataSourceSizes.add((Object)dataSource, segment.getSize());
            }
            countingMap = this.dataSourceCounts;
            synchronized (countingMap) {
                this.dataSourceCounts.add((Object)dataSource, 1L);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSegment(DataSegment segment) throws SegmentLoadingException {
        String dataSource = segment.getDataSource();
        Object object = this.lock;
        synchronized (object) {
            ReferenceCountingSegment oldQueryable;
            VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                log.info("Told to delete a queryable for a dataSource[%s] that doesn't exist.", new Object[]{dataSource});
                return;
            }
            PartitionChunk removed = loadedIntervals.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)null));
            ReferenceCountingSegment referenceCountingSegment = oldQueryable = removed == null ? null : (ReferenceCountingSegment)removed.getObject();
            if (oldQueryable != null) {
                CountingMap<String> countingMap = this.dataSourceSizes;
                synchronized (countingMap) {
                    this.dataSourceSizes.add((Object)dataSource, -segment.getSize());
                }
                countingMap = this.dataSourceCounts;
                synchronized (countingMap) {
                    this.dataSourceCounts.add((Object)dataSource, -1L);
                }
                try {
                    log.info("Attempting to close segment %s", new Object[]{segment.getIdentifier()});
                    oldQueryable.close();
                }
                catch (IOException e) {
                    log.makeAlert((Throwable)e, "Exception closing segment", new Object[0]).addData("dataSource", (Object)dataSource).addData("segmentId", (Object)segment.getIdentifier()).emit();
                }
            } else {
                log.info("Told to delete a queryable on dataSource[%s] for interval[%s] and version [%s] that I don't have.", new Object[]{dataSource, segment.getInterval(), segment.getVersion()});
            }
        }
        this.segmentLoader.cleanup(segment);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final Function<Query<T>, ServiceMetricEvent.Builder> builderFn = ServerManager.getBuilderFn(toolChest);
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = query.getDataSource();
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat((Function)new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create((Iterable)holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, (ReferenceCountingSegment)input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), builderFn, cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), builderFn, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return (String)Iterables.getOnlyElement((Iterable)dataSource.getNames());
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", new Object[]{query.getClass()}).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final Function<Query<T>, ServiceMetricEvent.Builder> builderFn = ServerManager.getBuilderFn(toolChest);
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), (Object)input.getVersion());
                if (entry == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Arrays.asList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, builderFn, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)queryRunners)), toolChest), builderFn, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, final QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        return CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new SpecificSegmentQueryRunner((QueryRunner)new MetricsEmittingQueryRunner(this.emitter, builderFn, (QueryRunner)new BySegmentQueryRunner(adapter.getIdentifier(), adapter.getDataInterval().getStart(), new CachingQueryRunner(adapter.getIdentifier(), segmentDescriptor, this.objectMapper, this.cache, (QueryToolChest)toolChest, new MetricsEmittingQueryRunner(this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(input);
            }
        }, (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, adapter, segmentDescriptor), "query/segment/time", (Map)ImmutableMap.of((Object)"segment", (Object)adapter.getIdentifier())), this.cachingExec, this.cacheConfig)), "query/segmentAndCache/time", (Map)ImmutableMap.of((Object)"segment", (Object)adapter.getIdentifier())).withWaitMeasuredFromNow(), segmentSpec), builderFn, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false);
    }

    private static <T> Function<Query<T>, ServiceMetricEvent.Builder> getBuilderFn(final QueryToolChest<T, Query<T>> toolChest) {
        return new Function<Query<T>, ServiceMetricEvent.Builder>(){

            @Nullable
            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(input);
            }
        };
    }
}

