/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization.jetty;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.metamx.common.logger.Logger;
import io.druid.server.initialization.jetty.ServletFilterHolder;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.servlets.QoSFilter;

public class JettyBindings {
    private static final Logger log = new Logger(JettyBindings.class);

    private JettyBindings() {
    }

    public static void addQosFilter(Binder binder, String path, int maxRequests) {
        if (maxRequests <= 0) {
            return;
        }
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class).addBinding().toInstance((Object)new QosFilterHolder(path, maxRequests));
    }

    private static class QosFilterHolder
    implements ServletFilterHolder {
        private final String path;
        private final int maxRequests;

        public QosFilterHolder(String path, int maxRequests) {
            this.path = path;
            this.maxRequests = maxRequests;
        }

        @Override
        public Filter getFilter() {
            return new QoSFilter();
        }

        @Override
        public Class<? extends Filter> getFilterClass() {
            return QoSFilter.class;
        }

        @Override
        public Map<String, String> getInitParameters() {
            return ImmutableMap.of((Object)"maxRequests", (Object)String.valueOf(this.maxRequests));
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public EnumSet<DispatcherType> getDispatcherType() {
            return null;
        }
    }
}

