/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.listener.announcer;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.server.listener.announcer.ListeningAnnouncerConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;

public class ListenerDiscoverer {
    private static final Logger LOG = new Logger(ListenerDiscoverer.class);
    private volatile Map<HostAndPort, Long> lastSeenMap = ImmutableMap.of();
    private final CuratorFramework cf;
    private final ListeningAnnouncerConfig listeningAnnouncerConfig;
    private final Object startStopSync = new Object();
    private volatile boolean started = false;

    @Inject
    public ListenerDiscoverer(CuratorFramework cf, ListeningAnnouncerConfig listeningAnnouncerConfig) {
        this.cf = cf;
        this.listeningAnnouncerConfig = listeningAnnouncerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (this.started) {
                LOG.debug("Already started", new Object[0]);
                return;
            }
            this.started = true;
            LOG.info("Started", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (!this.started) {
                LOG.debug("Already stopped", new Object[0]);
                return;
            }
            LOG.info("Stopped", new Object[0]);
            this.started = false;
        }
    }

    public Collection<HostAndPort> getNodes(String listener_key) throws IOException {
        return this.getCurrentNodes(listener_key).keySet();
    }

    Map<HostAndPort, Long> getCurrentNodes(String listener_key) throws IOException {
        Collection children;
        HashMap<HostAndPort, Long> retVal = new HashMap<HostAndPort, Long>();
        String zkPath = this.listeningAnnouncerConfig.getAnnouncementPath(listener_key);
        try {
            children = (Collection)this.cf.getChildren().forPath(zkPath);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Throwable)e, "No path found at [%s]", new Object[]{zkPath});
            return ImmutableMap.of();
        }
        catch (Exception e) {
            throw new IOException("Error getting children for " + zkPath, e);
        }
        for (String child : children) {
            String childPath = ZKPaths.makePath((String)zkPath, (String)child);
            try {
                byte[] data;
                try {
                    data = (byte[])((GetDataWatchBackgroundStatable)this.cf.getData().decompressed()).forPath(childPath);
                }
                catch (Exception e) {
                    throw new IOException("Error getting data for " + childPath, e);
                }
                if (data == null) {
                    LOG.debug("Lost data at path [%s]", new Object[]{childPath});
                    continue;
                }
                HostAndPort hostAndPort = HostAndPort.fromString((String)child);
                Long l = ByteBuffer.wrap(data).getLong();
                retVal.put(hostAndPort, l);
            }
            catch (IllegalArgumentException iae) {
                LOG.warn((Throwable)iae, "Error parsing [%s]", new Object[]{childPath});
            }
        }
        return ImmutableMap.copyOf(retVal);
    }

    public synchronized Collection<HostAndPort> getNewNodes(String listener_key) throws IOException {
        final Map<HostAndPort, Long> priorSeenMap = this.lastSeenMap;
        final Map<HostAndPort, Long> currentMap = this.getCurrentNodes(listener_key);
        Collection retVal = Collections2.filter(currentMap.keySet(), (Predicate)new Predicate<HostAndPort>(){

            public boolean apply(HostAndPort input) {
                Long l = (Long)priorSeenMap.get(input);
                return l == null || l < (Long)currentMap.get(input);
            }
        });
        this.lastSeenMap = currentMap;
        return retVal;
    }

    public Collection<String> discoverChildren(@Nullable String key_base) throws IOException {
        String zkPath = Strings.isNullOrEmpty((String)key_base) ? this.listeningAnnouncerConfig.getListenersPath() : this.listeningAnnouncerConfig.getAnnouncementPath(key_base);
        try {
            return (Collection)this.cf.getChildren().forPath(zkPath);
        }
        catch (KeeperException.NoChildrenForEphemeralsException | KeeperException.NoNodeException e) {
            LOG.warn(e, "Path [%s] not discoverable", new Object[]{zkPath});
            return ImmutableList.of();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

