/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.server.metrics.EventReceiverFirehoseMetric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EventReceiverFirehoseRegister {
    private static final Logger log = new Logger(EventReceiverFirehoseRegister.class);
    private final ConcurrentMap<String, EventReceiverFirehoseMetric> metrics = new ConcurrentHashMap<String, EventReceiverFirehoseMetric>();

    public void register(String serviceName, EventReceiverFirehoseMetric metric) {
        log.info("Registering EventReceiverFirehoseMetric for service [%s]", new Object[]{serviceName});
        if (this.metrics.putIfAbsent(serviceName, metric) != null) {
            throw new ISE("Service [%s] is already registered!", new Object[]{serviceName});
        }
    }

    public Iterable<Map.Entry<String, EventReceiverFirehoseMetric>> getMetrics() {
        return this.metrics.entrySet();
    }

    public void unregister(String serviceName) {
        log.info("Unregistering EventReceiverFirehoseMetric for service [%s]", new Object[]{serviceName});
        if (this.metrics.remove(serviceName) == null) {
            log.warn("Unregistering a non-exist service. Service [%s] never exists.", new Object[0]);
        }
    }
}

