/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.JvmCpuMonitor;
import com.metamx.metrics.JvmMonitor;
import com.metamx.metrics.Monitor;
import com.metamx.metrics.MonitorScheduler;
import com.metamx.metrics.MonitorSchedulerConfig;
import com.metamx.metrics.SysMonitor;
import io.druid.concurrent.Execs;
import io.druid.guice.DruidBinders;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.query.ExecutorServiceMonitor;
import io.druid.server.metrics.DataSourceTaskIdHolder;
import io.druid.server.metrics.DruidMonitorSchedulerConfig;
import io.druid.server.metrics.EventReceiverFirehoseRegister;
import io.druid.server.metrics.MonitorsConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MetricsModule
implements Module {
    private static final Logger log = new Logger(MetricsModule.class);

    public static void register(Binder binder, Class<? extends Monitor> monitorClazz) {
        DruidBinders.metricMonitorBinder(binder).addBinding().toInstance(monitorClazz);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.monitoring", DruidMonitorSchedulerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.monitoring", MonitorsConfig.class);
        DruidBinders.metricMonitorBinder(binder);
        binder.bind(DataSourceTaskIdHolder.class).in(LazySingleton.class);
        binder.bind(EventReceiverFirehoseRegister.class).in(LazySingleton.class);
        binder.bind(ExecutorServiceMonitor.class).in(LazySingleton.class);
        binder.bind(Key.get(MonitorScheduler.class, (Annotation)Names.named((String)"ForTheEagerness"))).to(MonitorScheduler.class).asEagerSingleton();
    }

    @Provides
    @ManageLifecycle
    public MonitorScheduler getMonitorScheduler(Supplier<DruidMonitorSchedulerConfig> config, MonitorsConfig monitorsConfig, Set<Class<? extends Monitor>> monitorSet, ServiceEmitter emitter, Injector injector) {
        ArrayList monitors = Lists.newArrayList();
        for (Class monitorClass : Iterables.concat(monitorsConfig.getMonitors(), monitorSet)) {
            Monitor monitor = (Monitor)injector.getInstance(monitorClass);
            log.info("Adding monitor[%s]", new Object[]{monitor});
            monitors.add(monitor);
        }
        return new MonitorScheduler((MonitorSchedulerConfig)config.get(), Execs.scheduledSingleThreaded((String)"MonitorScheduler-%s"), emitter, (List)monitors);
    }

    @Provides
    @ManageLifecycle
    public JvmMonitor getJvmMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JvmMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }

    @Provides
    @ManageLifecycle
    public JvmCpuMonitor getJvmCpuMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JvmCpuMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }

    @Provides
    @ManageLifecycle
    public SysMonitor getSysMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new SysMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }
}

