/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.client.BrokerSegmentWatcherConfig;
import io.druid.client.BrokerServerView;
import io.druid.client.CachingClusteredClient;
import io.druid.client.TimelineServerView;
import io.druid.client.cache.CacheConfig;
import io.druid.client.cache.CacheMonitor;
import io.druid.client.selector.CustomTierSelectorStrategyConfig;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.client.selector.TierSelectorStrategy;
import io.druid.discovery.DruidService;
import io.druid.discovery.LookupNodeService;
import io.druid.guice.CacheModule;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.RetryQueryRunnerConfig;
import io.druid.query.lookup.LookupModule;
import io.druid.server.BrokerQueryResource;
import io.druid.server.ClientInfoResource;
import io.druid.server.ClientQuerySegmentWalker;
import io.druid.server.coordination.broker.DruidBroker;
import io.druid.server.http.BrokerResource;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.metrics.MetricsModule;
import io.druid.server.metrics.QueryCountStatsProvider;
import io.druid.sql.guice.SqlModule;
import io.druid.timeline.PruneLoadSpec;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="broker", description="Runs a broker node, see http://druid.io/docs/latest/Broker.html for a description")
public class CliBroker
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);

    public CliBroker() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/broker");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8082);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8282);
                binder.bindConstant().annotatedWith(PruneLoadSpec.class).to(true);
                binder.bind(CachingClusteredClient.class).in(LazySingleton.class);
                binder.bind(BrokerServerView.class).in(LazySingleton.class);
                binder.bind(TimelineServerView.class).to(BrokerServerView.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.cache", CacheConfig.class);
                binder.install((Module)new CacheModule());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select", TierSelectorStrategy.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select.tier.custom", CustomTierSelectorStrategyConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.balancer", ServerSelectorStrategy.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.retryPolicy", RetryQueryRunnerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.segment", BrokerSegmentWatcherConfig.class);
                binder.bind(QuerySegmentWalker.class).to(ClientQuerySegmentWalker.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
                binder.bind(BrokerQueryResource.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, BrokerQueryResource.class);
                binder.bind(QueryCountStatsProvider.class).to(BrokerQueryResource.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, BrokerResource.class);
                Jerseys.addResource((Binder)binder, ClientInfoResource.class);
                LifecycleModule.register((Binder)binder, BrokerQueryResource.class);
                LifecycleModule.register((Binder)binder, DruidBroker.class);
                MetricsModule.register((Binder)binder, CacheMonitor.class);
                LifecycleModule.register((Binder)binder, Server.class);
                binder.bind(ServerRunnable.DiscoverySideEffectsProvider.Child.class).toProvider((Provider)new ServerRunnable.DiscoverySideEffectsProvider("broker", (List<Class<? extends DruidService>>)ImmutableList.of(LookupNodeService.class))).in(LazySingleton.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(ServerRunnable.DiscoverySideEffectsProvider.Child.class));
            }
        }, (Object)new LookupModule(), (Object)new SqlModule());
    }
}

