/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.druid.audit.AuditManager;
import io.druid.cli.CliOverlord;
import io.druid.cli.CoordinatorJettyServerInitializer;
import io.druid.cli.CoordinatorOverlordRedirectInfo;
import io.druid.cli.ServerRunnable;
import io.druid.client.CoordinatorServerView;
import io.druid.client.coordinator.Coordinator;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.discovery.DruidService;
import io.druid.guice.ConditionalMultibind;
import io.druid.guice.ConfigProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import io.druid.guice.annotations.Global;
import io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.http.client.HttpClient;
import io.druid.metadata.MetadataRuleManager;
import io.druid.metadata.MetadataRuleManagerConfig;
import io.druid.metadata.MetadataRuleManagerProvider;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.metadata.MetadataSegmentManagerConfig;
import io.druid.metadata.MetadataSegmentManagerProvider;
import io.druid.metadata.MetadataStorage;
import io.druid.metadata.MetadataStorageProvider;
import io.druid.server.audit.AuditManagerProvider;
import io.druid.server.coordinator.BalancerStrategyFactory;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorCleanupPendingSegments;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.LoadQueueTaskMaster;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentKiller;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentMerger;
import io.druid.server.coordinator.helper.DruidCoordinatorVersionConverter;
import io.druid.server.http.ClusterResource;
import io.druid.server.http.CoordinatorDynamicConfigsResource;
import io.druid.server.http.CoordinatorRedirectInfo;
import io.druid.server.http.CoordinatorResource;
import io.druid.server.http.DatasourcesResource;
import io.druid.server.http.IntervalsResource;
import io.druid.server.http.LookupCoordinatorResource;
import io.druid.server.http.MetadataResource;
import io.druid.server.http.RedirectFilter;
import io.druid.server.http.RedirectInfo;
import io.druid.server.http.RulesResource;
import io.druid.server.http.ServersResource;
import io.druid.server.http.TiersResource;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.lookup.cache.LookupCoordinatorManager;
import io.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jetty.server.Server;

@Command(name="coordinator", description="Runs the Coordinator, see http://druid.io/docs/latest/Coordinator.html for a description.")
public class CliCoordinator
extends ServerRunnable {
    private static final Logger log = new Logger(CliCoordinator.class);
    private Properties properties;
    private boolean beOverlord;

    public CliCoordinator() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.properties = properties;
        this.beOverlord = CliCoordinator.isOverlord(properties);
        if (this.beOverlord) {
            log.info("Coordinator is configured to act as Overlord as well.", new Object[0]);
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        ArrayList<? extends Module> modules = new ArrayList<Module>();
        modules.add(new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/coordinator");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8081);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8281);
                ConfigProvider.bind((Binder)binder, DruidCoordinatorConfig.class);
                binder.bind(MetadataStorage.class).toProvider(MetadataStorageProvider.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", MetadataSegmentManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", MetadataRuleManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.lookups", LookupCoordinatorManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.balancer", BalancerStrategyFactory.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                if (CliCoordinator.this.beOverlord) {
                    binder.bind(RedirectInfo.class).to(CoordinatorOverlordRedirectInfo.class).in(LazySingleton.class);
                } else {
                    binder.bind(RedirectInfo.class).to(CoordinatorRedirectInfo.class).in(LazySingleton.class);
                }
                binder.bind(MetadataSegmentManager.class).toProvider(MetadataSegmentManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(MetadataRuleManager.class).toProvider(MetadataRuleManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(AuditManager.class).toProvider(AuditManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(IndexingServiceClient.class).in(LazySingleton.class);
                binder.bind(CoordinatorServerView.class).in(LazySingleton.class);
                binder.bind(LookupCoordinatorManager.class).in(LazySingleton.class);
                binder.bind(DruidCoordinator.class);
                LifecycleModule.register((Binder)binder, MetadataStorage.class);
                LifecycleModule.register((Binder)binder, DruidCoordinator.class);
                binder.bind(JettyServerInitializer.class).to(CoordinatorJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, CoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorDynamicConfigsResource.class);
                Jerseys.addResource((Binder)binder, TiersResource.class);
                Jerseys.addResource((Binder)binder, RulesResource.class);
                Jerseys.addResource((Binder)binder, ServersResource.class);
                Jerseys.addResource((Binder)binder, DatasourcesResource.class);
                Jerseys.addResource((Binder)binder, MetadataResource.class);
                Jerseys.addResource((Binder)binder, IntervalsResource.class);
                Jerseys.addResource((Binder)binder, LookupCoordinatorResource.class);
                Jerseys.addResource((Binder)binder, ClusterResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                LifecycleModule.register((Binder)binder, DatasourcesResource.class);
                ConditionalMultibind.create((Properties)CliCoordinator.this.properties, (Binder)binder, DruidCoordinatorHelper.class, CoordinatorIndexingServiceHelper.class).addConditionBinding("druid.coordinator.merge.on", Predicates.equalTo((Object)"true"), DruidCoordinatorSegmentMerger.class).addConditionBinding("druid.coordinator.conversion.on", Predicates.equalTo((Object)"true"), DruidCoordinatorVersionConverter.class).addConditionBinding("druid.coordinator.kill.on", Predicates.equalTo((Object)"true"), DruidCoordinatorSegmentKiller.class).addConditionBinding("druid.coordinator.kill.pendingSegments.on", Predicates.equalTo((Object)"true"), DruidCoordinatorCleanupPendingSegments.class);
                binder.bind(ServerRunnable.DiscoverySideEffectsProvider.Child.class).annotatedWith(Coordinator.class).toProvider((Provider)new ServerRunnable.DiscoverySideEffectsProvider("coordinator", (List<Class<? extends DruidService>>)ImmutableList.of())).in(LazySingleton.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(ServerRunnable.DiscoverySideEffectsProvider.Child.class, Coordinator.class));
            }

            @Provides
            @LazySingleton
            public LoadQueueTaskMaster getLoadQueueTaskMaster(CuratorFramework curator, ObjectMapper jsonMapper, ScheduledExecutorFactory factory, DruidCoordinatorConfig config, @Global HttpClient httpClient, ZkPathsConfig zkPaths) {
                return new LoadQueueTaskMaster(curator, jsonMapper, factory.create(1, "Master-PeonExec--%d"), Executors.newSingleThreadExecutor(), config, httpClient, zkPaths);
            }
        });
        if (this.beOverlord) {
            modules.addAll(new CliOverlord().getModules(false));
        }
        return modules;
    }

    public static boolean isOverlord(Properties properties) {
        return Boolean.valueOf(properties.getProperty("druid.coordinator.asOverlord.enabled"));
    }
}

