/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import io.airlift.airline.Command;
import io.druid.cli.MiddleManagerJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.discovery.DruidService;
import io.druid.discovery.WorkerNodeService;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.IndexingServiceModuleHelper;
import io.druid.guice.IndexingServiceTaskLogsModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.overlord.ForkingTaskRunner;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.worker.Worker;
import io.druid.indexing.worker.WorkerCuratorCoordinator;
import io.druid.indexing.worker.WorkerTaskMonitor;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.indexing.worker.http.WorkerResource;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.DruidNode;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="middleManager", description="Runs a Middle Manager, this is a \"task\" node used as part of the remote indexing service, see http://druid.io/docs/latest/design/middlemanager.html for a description")
public class CliMiddleManager
extends ServerRunnable {
    private static final Logger log = new Logger(CliMiddleManager.class);

    public CliMiddleManager() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/middlemanager");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8091);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8291);
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                binder.bind(TaskRunner.class).to(ForkingTaskRunner.class);
                binder.bind(ForkingTaskRunner.class).in(LazySingleton.class);
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of(null));
                binder.bind(WorkerTaskMonitor.class).in(ManageLifecycle.class);
                binder.bind(WorkerCuratorCoordinator.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, WorkerTaskMonitor.class);
                binder.bind(JettyServerInitializer.class).toInstance((Object)new MiddleManagerJettyServerInitializer());
                Jerseys.addResource((Binder)binder, WorkerResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                binder.bind(ServerRunnable.DiscoverySideEffectsProvider.Child.class).toProvider((Provider)new ServerRunnable.DiscoverySideEffectsProvider("middleManager", (List<Class<? extends DruidService>>)ImmutableList.of(WorkerNodeService.class))).in(LazySingleton.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(ServerRunnable.DiscoverySideEffectsProvider.Child.class));
            }

            @Provides
            @LazySingleton
            public Worker getWorker(@Self DruidNode node, WorkerConfig config) {
                return new Worker(node.getServiceScheme(), node.getHostAndPortToUse(), config.getIp(), config.getCapacity(), config.getVersion());
            }

            @Provides
            @LazySingleton
            public WorkerNodeService getWorkerNodeService(WorkerConfig workerConfig) {
                return new WorkerNodeService(workerConfig.getIp(), workerConfig.getCapacity(), workerConfig.getVersion());
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceTaskLogsModule());
    }
}

