/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.cli.GuiceRunnable;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.client.cache.CacheConfig;
import io.druid.client.coordinator.CoordinatorClient;
import io.druid.guice.Binders;
import io.druid.guice.CacheModule;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.guice.PolyBind;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.QueryablePeonModule;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.indexing.common.RetryPolicyConfig;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.actions.LocalTaskActionClientFactory;
import io.druid.indexing.common.actions.RemoteTaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.HeapMemoryTaskStorage;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.ThreadPoolTaskRunner;
import io.druid.indexing.worker.executor.ExecutorLifecycle;
import io.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.lookup.LookupModule;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.OmniDataSegmentArchiver;
import io.druid.segment.loading.OmniDataSegmentKiller;
import io.druid.segment.loading.OmniDataSegmentMover;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.StorageLocationConfig;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import io.druid.segment.realtime.firehose.ServiceAnnouncingChatHandlerProvider;
import io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierFactory;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.coordination.BatchDataSegmentAnnouncer;
import io.druid.server.coordination.ServerType;
import io.druid.server.http.SegmentListerResource;
import io.druid.server.initialization.jetty.ChatHandlerServerModule;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jetty.server.Server;

@Command(name="peon", description="Runs a Peon, this is an individual forked \"task\" used as part of the indexing service. This should rarely, if ever, be used directly. See http://druid.io/docs/latest/design/peons.html for a description")
public class CliPeon
extends GuiceRunnable {
    @Arguments(description="task.json status.json", required=true)
    public List<String> taskAndStatusFile;
    @Option(name={"--nodeType"}, title="nodeType", description="Set the node type to expose on ZK")
    public String nodeType = "indexer-executor";
    private static final Logger log = new Logger(CliPeon.class);
    @Inject
    private Properties properties;

    public CliPeon() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/peon");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(ServiceAnnouncingChatHandlerProvider.class));
                MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
                handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
                handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(NoopChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(TaskToolboxFactory.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.peon.taskActionClient.retry", RetryPolicyConfig.class);
                this.configureTaskActionClient(binder);
                binder.bind(RetryPolicyFactory.class).in(LazySingleton.class);
                Binders.dataSegmentKillerBinder((Binder)binder);
                binder.bind(DataSegmentKiller.class).to(OmniDataSegmentKiller.class).in(LazySingleton.class);
                Binders.dataSegmentMoverBinder((Binder)binder);
                binder.bind(DataSegmentMover.class).to(OmniDataSegmentMover.class).in(LazySingleton.class);
                Binders.dataSegmentArchiverBinder((Binder)binder);
                binder.bind(DataSegmentArchiver.class).to(OmniDataSegmentArchiver.class).in(LazySingleton.class);
                binder.bind(ExecutorLifecycle.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, ExecutorLifecycle.class);
                binder.bind(ExecutorLifecycleConfig.class).toInstance((Object)new ExecutorLifecycleConfig().setTaskFile(new File(CliPeon.this.taskAndStatusFile.get(0))).setStatusFile(new File(CliPeon.this.taskAndStatusFile.get(1))));
                binder.bind(TaskRunner.class).to(ThreadPoolTaskRunner.class);
                binder.bind(QuerySegmentWalker.class).to(ThreadPoolTaskRunner.class);
                binder.bind(ThreadPoolTaskRunner.class).in(ManageLifecycle.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime.cache", CacheConfig.class);
                binder.install((Module)new CacheModule());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.segment.handoff", CoordinatorBasedSegmentHandoffNotifierConfig.class);
                binder.bind(SegmentHandoffNotifierFactory.class).to(CoordinatorBasedSegmentHandoffNotifierFactory.class).in(LazySingleton.class);
                binder.bind(SegmentLoaderConfig.class).toInstance((Object)new SegmentLoaderConfig().withLocations(Arrays.asList(new StorageLocationConfig[0])));
                binder.bind(CoordinatorClient.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, SegmentListerResource.class);
                binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig(ServerType.fromString((String)CliPeon.this.nodeType)));
                LifecycleModule.register((Binder)binder, Server.class);
            }

            private void configureTaskActionClient(Binder binder) {
                PolyBind.createChoice((Binder)binder, (String)"druid.peon.mode", (Key)Key.get(TaskActionClientFactory.class), (Key)Key.get(RemoteTaskActionClientFactory.class));
                MapBinder taskActionBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskActionClientFactory.class));
                taskActionBinder.addBinding((Object)"local").to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
                binder.bind(TaskStorage.class).to(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(LazySingleton.class);
                taskActionBinder.addBinding((Object)"remote").to(RemoteTaskActionClientFactory.class).in(LazySingleton.class);
            }

            @Provides
            @LazySingleton
            public Task readTask(@Json ObjectMapper mapper, ExecutorLifecycleConfig config) {
                try {
                    return (Task)mapper.readValue(config.getTaskFile(), Task.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Provides
            @LazySingleton
            @Named(value="druidDataSource")
            public String getDataSourceFromTask(Task task) {
                return task.getDataSource();
            }

            @Provides
            @LazySingleton
            @Named(value="druidTaskId")
            public String getTaskIDFromTask(Task task) {
                return task.getId();
            }

            @Provides
            public SegmentListerResource getSegmentListerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @Nullable BatchDataSegmentAnnouncer announcer) {
                return new SegmentListerResource(jsonMapper, smileMapper, announcer, null);
            }
        }, (Object)new QueryablePeonModule(), (Object)new IndexingServiceFirehoseModule(), (Object)new ChatHandlerServerModule(this.properties), (Object)new LookupModule());
    }

    @Override
    public void run() {
        try {
            Injector injector = this.makeInjector();
            try {
                final Lifecycle lifecycle = this.initLifecycle(injector);
                Thread hook = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        log.info("Running shutdown hook", new Object[0]);
                        lifecycle.stop();
                    }
                });
                Runtime.getRuntime().addShutdownHook(hook);
                ((ExecutorLifecycle)injector.getInstance(ExecutorLifecycle.class)).join();
                Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                for (Thread thread : threadSet) {
                    if (thread.isDaemon() || thread == Thread.currentThread()) continue;
                    log.info("Thread [%s] is non daemon.", new Object[]{thread});
                }
                lifecycle.stop();
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException e) {
                    log.warn("Cannot remove shutdown hook, already shutting down", new Object[0]);
                }
            }
            catch (Throwable t) {
                log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            log.info("Finished peon task", new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

