/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import io.druid.cli.CliCoordinator;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.http.OverlordProxyServlet;
import io.druid.server.http.RedirectFilter;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthenticationUtils;
import io.druid.server.security.AuthenticatorMapper;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

class CoordinatorJettyServerInitializer
implements JettyServerInitializer {
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/favicon.ico", "/css/*", "/druid.js", "/druid.css", "/pages/*", "/fonts/*", "/old-console/*", "/coordinator/false", "/overlord/false", "/status/health", "/druid/coordinator/v1/isLeader"});
    private static Logger log = new Logger(CoordinatorJettyServerInitializer.class);
    private final DruidCoordinatorConfig config;
    private final boolean beOverlord;

    @Inject
    CoordinatorJettyServerInitializer(DruidCoordinatorConfig config, Properties properties) {
        this.config = config;
        this.beOverlord = CliCoordinator.isOverlord(properties);
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        root.addServlet(holderPwd, "/");
        if (this.config.getConsoleStatic() == null) {
            ResourceCollection staticResources = this.beOverlord ? new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"io/druid/console"), Resource.newClassPathResource((String)"static"), Resource.newClassPathResource((String)"indexer_static")}) : new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"io/druid/console"), Resource.newClassPathResource((String)"static")});
            root.setBaseResource((Resource)staticResources);
        } else {
            root.setResourceBase(this.config.getConsoleStatic());
        }
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        List authenticators = null;
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
        root.addFilter(GuiceFilter.class, "/info/*", null);
        root.addFilter(GuiceFilter.class, "/druid/coordinator/*", null);
        if (this.beOverlord) {
            root.addFilter(GuiceFilter.class, "/druid/indexer/*", null);
        }
        root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
        root.addFilter(GuiceFilter.class, "/coordinator/*", null);
        if (!this.beOverlord) {
            root.addServlet(new ServletHolder((Servlet)injector.getInstance(OverlordProxyServlet.class)), "/druid/indexer/*");
        }
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root)});
        server.setHandler((Handler)handlerList);
    }
}

