/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.inject.Inject;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.http.OverlordRedirectInfo;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.http.CoordinatorRedirectInfo;
import io.druid.server.http.RedirectInfo;
import java.net.URL;

public class CoordinatorOverlordRedirectInfo
implements RedirectInfo {
    private final OverlordRedirectInfo overlordRedirectInfo;
    private final CoordinatorRedirectInfo coordinatorRedirectInfo;

    @Inject
    public CoordinatorOverlordRedirectInfo(TaskMaster taskMaster, DruidCoordinator druidCoordinator) {
        this.overlordRedirectInfo = new OverlordRedirectInfo(taskMaster);
        this.coordinatorRedirectInfo = new CoordinatorRedirectInfo(druidCoordinator);
    }

    public boolean doLocal(String requestURI) {
        return this.isOverlordRequest(requestURI) ? this.overlordRedirectInfo.doLocal(requestURI) : this.coordinatorRedirectInfo.doLocal(requestURI);
    }

    public URL getRedirectURL(String queryString, String requestURI) {
        return this.isOverlordRequest(requestURI) ? this.overlordRedirectInfo.getRedirectURL(queryString, requestURI) : this.coordinatorRedirectInfo.getRedirectURL(queryString, requestURI);
    }

    private boolean isOverlordRequest(String requestURI) {
        return requestURI.startsWith("/druid/indexer");
    }
}

