/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.guice.ExtensionsConfig;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.tesla.aether.Repository;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Command(name="pull-deps", description="Pull down dependencies to the local repository specified by druid.extensions.localRepository, extensions directory specified by druid.extensions.extensionsDir and hadoop dependencies directory specified by druid.extensions.hadoopDependenciesDir")
public class PullDependencies
implements Runnable {
    private static final Logger log = new Logger(PullDependencies.class);
    private static final Set<String> exclusions = Sets.newHashSet();
    private static final List<String> DEFAULT_REMOTE_REPOSITORIES = ImmutableList.of((Object)"https://repo1.maven.org/maven2/");
    private TeslaAether aether;
    @Inject
    public ExtensionsConfig extensionsConfig;
    @Option(name={"-c", "--coordinate"}, title="coordinate", description="Extension coordinate to pull down, followed by a maven coordinate, e.g. io.druid.extensions:mysql-metadata-storage", required=false)
    public List<String> coordinates = Lists.newArrayList();
    @Option(name={"-h", "--hadoop-coordinate"}, title="hadoop coordinate", description="Hadoop dependency to pull down, followed by a maven coordinate, e.g. org.apache.hadoop:hadoop-client:2.4.0", required=false)
    public List<String> hadoopCoordinates = Lists.newArrayList();
    @Option(name={"--no-default-hadoop"}, description="Don't pull down the default hadoop coordinate, i.e., org.apache.hadoop:hadoop-client:2.3.0. If `-h` option is supplied, then default hadoop coordinate will not be downloaded.", required=false)
    public boolean noDefaultHadoop = false;
    @Option(name={"--clean"}, title="Remove exisiting extension and hadoop dependencies directories before pulling down dependencies.", required=false)
    public boolean clean = false;
    @Option(name={"-l", "--localRepository"}, title="A local repository that Maven will use to put downloaded files. Then pull-deps will lay these files out into the extensions directory as needed.", required=false)
    public String localRepository = StringUtils.format((String)"%s/%s", (Object[])new Object[]{System.getProperty("user.home"), ".m2/repository"});
    @Option(name={"-r", "--remoteRepository"}, title="Add a remote repository. Unless --no-default-remote-repositories is provided, these will be used after https://repo1.maven.org/maven2/", required=false)
    List<String> remoteRepositories = Lists.newArrayList();
    @Option(name={"--no-default-remote-repositories"}, description="Don't use the default remote repositories, only use the repositories provided directly via --remoteRepository", required=false)
    public boolean noDefaultRemoteRepositories = false;
    @Option(name={"-d", "--defaultVersion"}, title="Version to use for extension artifacts without version information.", required=false)
    public String defaultVersion = PullDependencies.class.getPackage().getImplementationVersion();

    public PullDependencies() {
    }

    PullDependencies(TeslaAether aether, ExtensionsConfig extensionsConfig) {
        this.aether = aether;
        this.extensionsConfig = extensionsConfig;
    }

    @Override
    public void run() {
        if (this.aether == null) {
            this.aether = this.getAetherClient();
        }
        File extensionsDir = new File(this.extensionsConfig.getDirectory());
        File hadoopDependenciesDir = new File(this.extensionsConfig.getHadoopDependenciesDir());
        try {
            if (this.clean) {
                FileUtils.deleteDirectory((File)extensionsDir);
                FileUtils.deleteDirectory((File)hadoopDependenciesDir);
            }
            FileUtils.forceMkdir((File)extensionsDir);
            FileUtils.forceMkdir((File)hadoopDependenciesDir);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Unable to clear or create extension directory at [%s]", new Object[]{extensionsDir});
            throw Throwables.propagate((Throwable)e);
        }
        log.info("Start pull-deps with local repository [%s] and remote repositories [%s]", new Object[]{this.localRepository, this.remoteRepositories});
        try {
            File currExtensionDir;
            Artifact versionedArtifact;
            log.info("Start downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            for (String coordinate : this.coordinates) {
                coordinate = coordinate.trim();
                versionedArtifact = this.getArtifact(coordinate);
                currExtensionDir = new File(extensionsDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(coordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir);
            }
            log.info("Finish downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            if (!this.noDefaultHadoop && this.hadoopCoordinates.isEmpty()) {
                this.hadoopCoordinates.addAll(TaskConfig.DEFAULT_DEFAULT_HADOOP_COORDINATES);
            }
            log.info("Start downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
            for (String hadoopCoordinate : this.hadoopCoordinates) {
                versionedArtifact = this.getArtifact(hadoopCoordinate);
                currExtensionDir = new File(hadoopDependenciesDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                currExtensionDir = new File(currExtensionDir, versionedArtifact.getVersion());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir);
            }
            log.info("Finish downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Artifact getArtifact(String coordinate) {
        DefaultArtifact versionedArtifact;
        try {
            versionedArtifact = new DefaultArtifact(coordinate);
        }
        catch (IllegalArgumentException e) {
            if (this.defaultVersion != null) {
                versionedArtifact = new DefaultArtifact(coordinate + ":" + this.defaultVersion);
            }
            throw e;
        }
        return versionedArtifact;
    }

    private void downloadExtension(Artifact versionedArtifact, File toLocation) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(versionedArtifact, "runtime"));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}), new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                String scope = node.getDependency().getScope();
                if (scope != null) {
                    if ((scope = StringUtils.toLowerCase((String)scope)).equals("provided")) {
                        return false;
                    }
                    if (scope.equals("test")) {
                        return false;
                    }
                    if (scope.equals("system")) {
                        return false;
                    }
                }
                if (this.accept(node.getArtifact())) {
                    return false;
                }
                for (DependencyNode parent : parents) {
                    if (!this.accept(parent.getArtifact())) continue;
                    return false;
                }
                return true;
            }

            private boolean accept(Artifact artifact) {
                return exclusions.contains(artifact.getGroupId());
            }
        }}));
        try {
            log.info("Start downloading extension [%s]", new Object[]{versionedArtifact});
            List artifacts = this.aether.resolveArtifacts(dependencyRequest);
            for (Artifact artifact : artifacts) {
                if (!exclusions.contains(artifact.getGroupId())) {
                    log.info("Adding file [%s] at [%s]", new Object[]{artifact.getFile().getName(), toLocation.getAbsolutePath()});
                    FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)toLocation);
                    continue;
                }
                log.debug("Skipped Artifact[%s]", new Object[]{artifact});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to resolve artifacts for [%s].", new Object[]{dependencyRequest});
            throw Throwables.propagate((Throwable)e);
        }
        log.info("Finish downloading extension [%s]", new Object[]{versionedArtifact});
    }

    private DefaultTeslaAether getAetherClient() {
        ArrayList remoteUriList = Lists.newArrayList();
        if (!this.noDefaultRemoteRepositories) {
            remoteUriList.addAll(DEFAULT_REMOTE_REPOSITORIES);
        }
        remoteUriList.addAll(this.remoteRepositories);
        ArrayList remoteRepositories = Lists.newArrayList();
        for (String uri : remoteUriList) {
            try {
                URI u = new URI(uri);
                Repository r = new Repository(uri);
                if (u.getUserInfo() != null) {
                    String[] auth = u.getUserInfo().split(":", 2);
                    if (auth.length == 2) {
                        r.setUsername(auth[0]);
                        r.setPassword(auth[1]);
                    } else {
                        log.warn("Invalid credentials in repository URI, expecting [<user>:<password>], got [%s] for [%s]", new Object[]{u.getUserInfo(), uri});
                    }
                }
                remoteRepositories.add(r);
            }
            catch (URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (log.isTraceEnabled() || log.isDebugEnabled()) {
            return new DefaultTeslaAether(this.localRepository, remoteRepositories.toArray(new Repository[remoteRepositories.size()]));
        }
        PrintStream oldOut = System.out;
        try {
            String uri;
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                }
            }, false, StringUtils.UTF8_STRING));
            uri = new DefaultTeslaAether(this.localRepository, remoteRepositories.toArray(new Repository[remoteRepositories.size()]));
            return uri;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        finally {
            System.setOut(oldOut);
        }
    }

    private void createExtensionDirectory(String coordinate, File atLocation) {
        if (atLocation.isDirectory()) {
            log.info("Directory [%s] already exists, skipping creating a directory", new Object[]{atLocation.getAbsolutePath()});
            return;
        }
        if (!atLocation.mkdir()) {
            throw new ISE("Unable to create directory at [%s] for coordinate [%s]", new Object[]{atLocation.getAbsolutePath(), coordinate});
        }
    }
}

