/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.cli.GuiceRunnable;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.IndexingServiceTaskLogsModule;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.HadoopTask;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnector;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.server.DruidNode;
import io.druid.tasklogs.TaskLogKiller;
import java.util.List;

@Command(name="reset-cluster", description="Cleanup all persisted state from metadata and deep storage.")
public class ResetCluster
extends GuiceRunnable {
    private static final Logger log = new Logger(ResetCluster.class);
    @Option(name={"--all"}, description="delete all state stored in metadata and deep storage")
    private boolean all;
    @Option(name={"--metadataStore"}, description="delete all records in metadata storage")
    private boolean metadataStore;
    @Option(name={"--segmentFiles"}, description="delete all segment files from deep storage")
    private boolean segmentFiles;
    @Option(name={"--taskLogs"}, description="delete all tasklogs")
    private boolean taskLogs;
    @Option(name={"--hadoopWorkingPath"}, description="delete hadoopWorkingPath")
    private boolean hadoopWorkingPath;

    public ResetCluster() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", Integer.valueOf(-1), null, true, false));
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
            }
        }, (Object)new IndexingServiceTaskLogsModule());
    }

    @Override
    public void run() {
        if (this.all) {
            this.hadoopWorkingPath = true;
            this.taskLogs = true;
            this.segmentFiles = true;
            this.metadataStore = true;
        }
        Injector injector = this.makeInjector();
        if (this.metadataStore) {
            this.resetMetadataStore(injector);
        }
        if (this.segmentFiles) {
            this.deleteAllSegmentFiles(injector);
        }
        if (this.taskLogs) {
            this.deleteAllTaskLogs(injector);
        }
        if (this.hadoopWorkingPath) {
            this.deleteIndexerHadoopWorkingDir(injector);
        }
    }

    private void resetMetadataStore(Injector injector) {
        String[] tables;
        log.info("===========================================================================", new Object[0]);
        log.info("Deleting all Records from Metadata Storage.", new Object[0]);
        log.info("===========================================================================", new Object[0]);
        MetadataStorageConnector connector = (MetadataStorageConnector)injector.getInstance(MetadataStorageConnector.class);
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)injector.getInstance(MetadataStorageTablesConfig.class);
        for (String table : tables = new String[]{tablesConfig.getDataSourceTable(), tablesConfig.getPendingSegmentsTable(), tablesConfig.getSegmentsTable(), tablesConfig.getRulesTable(), tablesConfig.getConfigTable(), tablesConfig.getTasksTable(), tablesConfig.getTaskLockTable(), tablesConfig.getTaskLogTable(), tablesConfig.getAuditTable(), tablesConfig.getSupervisorTable()}) {
            connector.deleteAllRecords(table);
        }
    }

    private void deleteAllSegmentFiles(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting all Segment Files.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            DataSegmentKiller segmentKiller = (DataSegmentKiller)injector.getInstance(DataSegmentKiller.class);
            segmentKiller.killAll();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup Segment Files.", new Object[0]);
        }
    }

    private void deleteAllTaskLogs(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting all TaskLogs.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            TaskLogKiller taskLogKiller = (TaskLogKiller)injector.getInstance(TaskLogKiller.class);
            taskLogKiller.killAll();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup TaskLogs.", new Object[0]);
        }
    }

    private void deleteIndexerHadoopWorkingDir(Injector injector) {
        try {
            log.info("===========================================================================", new Object[0]);
            log.info("Deleting hadoopWorkingPath.", new Object[0]);
            log.info("===========================================================================", new Object[0]);
            TaskConfig taskConfig = (TaskConfig)injector.getInstance(TaskConfig.class);
            HadoopTask.invokeForeignLoader((String)"io.druid.indexer.HadoopWorkingDirCleaner", (Object)new String[]{taskConfig.getHadoopWorkingPath()}, (ClassLoader)HadoopTask.buildClassLoader(null, (List)taskConfig.getDefaultHadoopCoordinates()));
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Failed to cleanup indexer hadoop working directory.", new Object[0]);
        }
    }
}

