/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import io.druid.guice.annotations.Json;
import io.druid.guice.http.DruidHttpClientConfig;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.AsyncQueryForwardingServlet;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.router.Router;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthenticationUtils;
import io.druid.server.security.AuthenticatorMapper;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class RouterJettyServerInitializer
implements JettyServerInitializer {
    private static Logger log = new Logger(RouterJettyServerInitializer.class);
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/status/health", "/druid/v2/sql/avatica/"});
    private final AsyncQueryForwardingServlet asyncQueryForwardingServlet;
    private final DruidHttpClientConfig httpClientConfig;

    @Inject
    public RouterJettyServerInitializer(@Router DruidHttpClientConfig httpClientConfig, AsyncQueryForwardingServlet asyncQueryForwardingServlet) {
        this.httpClientConfig = httpClientConfig;
        this.asyncQueryForwardingServlet = asyncQueryForwardingServlet;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        this.asyncQueryForwardingServlet.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        ServletHolder sh = new ServletHolder((Servlet)this.asyncQueryForwardingServlet);
        sh.setInitParameter("maxThreads", Integer.toString(this.httpClientConfig.getNumMaxThreads()));
        sh.setInitParameter("maxConnections", Integer.toString(this.httpClientConfig.getNumConnections()));
        sh.setInitParameter("idleTimeout", Long.toString(this.httpClientConfig.getReadTimeout().getMillis()));
        sh.setInitParameter("timeout", Long.toString(this.httpClientConfig.getReadTimeout().getMillis()));
        root.addServlet(sh, "/druid/v2/*");
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        List authenticators = null;
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(GuiceFilter.class, "/druid/router/*", null);
        root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root)});
        server.setHandler((Handler)handlerList);
    }
}

