/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.druid.cli.GuiceRunnable;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.DruidProcessingConfig;
import io.druid.segment.IndexIO;
import io.druid.segment.column.ColumnConfig;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;

@Command(name="validate-segments", description="Compare two segments for validation")
public class ValidateSegments
extends GuiceRunnable {
    private static final Logger log = new Logger(ValidateSegments.class);
    @Arguments(description="Two directories where each directory contains segment files to validate.", required=true)
    public List<String> directories;

    public ValidateSegments() {
        super(log);
    }

    @Override
    public void run() {
        if (this.directories.size() != 2) {
            throw new IAE("Please provide two segment directories to compare", new Object[0]);
        }
        Injector injector = this.makeInjector();
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        try {
            String dir1 = this.directories.get(0);
            String dir2 = this.directories.get(1);
            indexIO.validateTwoSegments(new File(dir1), new File(dir2));
            log.info("Segments [%s] and [%s] are identical", new Object[]{dir1, dir2});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/tool");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9999);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(DruidProcessingConfig.class).toInstance((Object)new DruidProcessingConfig(){

                    public String getFormatString() {
                        return "processing-%s";
                    }

                    public int intermediateComputeSizeBytes() {
                        return 0x6400000;
                    }

                    public int getNumThreads() {
                        return 1;
                    }

                    public int columnCacheSizeBytes() {
                        return 0x1900000;
                    }
                });
                binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
            }
        });
    }
}

