/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli.validate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.cli.GuiceRunnable;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.FirehoseModule;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.LocalDataStorageDruidModule;
import io.druid.guice.ParsersModule;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.IndexingHadoopModule;
import io.druid.indexing.common.task.Task;
import io.druid.initialization.DruidModule;
import io.druid.initialization.Initialization;
import io.druid.java.util.common.UOE;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.Query;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.output.NullWriter;

@Command(name="validator", description="Validates that a given Druid JSON object is correctly formatted")
public class DruidJsonValidator
extends GuiceRunnable {
    private static final Logger LOG = new Logger(DruidJsonValidator.class);
    private Writer logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    @Option(name={"-f"}, title="file", description="file to validate", required=true)
    public String jsonFile;
    @Option(name={"-t"}, title="type", description="the type of schema to validate", required=true)
    public String type;
    @Option(name={"-r"}, title="resource", description="optional resources required for validation", required=false)
    public String resource;
    @Option(name={"--log"}, title="toLogger", description="redirects any outputs to logger", required=false)
    public boolean toLogger;

    public DruidJsonValidator() {
        super(LOG);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/validator");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            }
        });
    }

    @Override
    public void run() {
        block17: {
            File file = new File(this.jsonFile);
            if (!file.exists()) {
                LOG.info("File[%s] does not exist.%n", new Object[]{file});
            }
            Injector injector = this.makeInjector();
            ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
            this.registerModules(jsonMapper, Iterables.concat((Iterable)Initialization.getFromExtensions((ExtensionsConfig)((ExtensionsConfig)injector.getInstance(ExtensionsConfig.class)), DruidModule.class), Arrays.asList(new FirehoseModule(), new IndexingHadoopModule(), new IndexingServiceFirehoseModule(), new LocalDataStorageDruidModule(), new ParsersModule())));
            ClassLoader loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : DruidJsonValidator.class.getClassLoader();
            if (this.toLogger) {
                this.logWriter = new NullWriter(){
                    private final Logger logger = new Logger(DruidJsonValidator.class);

                    public void write(char[] cbuf, int off, int len) {
                        this.logger.info(new String(cbuf, off, len), new Object[0]);
                    }
                };
            }
            try {
                if (this.type.equalsIgnoreCase("query")) {
                    jsonMapper.readValue(file, Query.class);
                    break block17;
                }
                if (this.type.equalsIgnoreCase("hadoopConfig")) {
                    jsonMapper.readValue(file, HadoopDruidIndexerConfig.class);
                    break block17;
                }
                if (this.type.equalsIgnoreCase("task")) {
                    jsonMapper.readValue(file, Task.class);
                    break block17;
                }
                if (this.type.equalsIgnoreCase("parse")) {
                    StringInputRowParser parser;
                    if (file.isFile()) {
                        this.logWriter.write("loading parse spec from file '" + file + "'");
                        parser = (StringInputRowParser)jsonMapper.readValue(file, StringInputRowParser.class);
                    } else if (loader.getResource(this.jsonFile) != null) {
                        this.logWriter.write("loading parse spec from resource '" + this.jsonFile + "'");
                        parser = (StringInputRowParser)jsonMapper.readValue(loader.getResource(this.jsonFile), StringInputRowParser.class);
                    } else {
                        this.logWriter.write("cannot find proper spec from 'file'.. regarding it as a json spec");
                        parser = (StringInputRowParser)jsonMapper.readValue(this.jsonFile, StringInputRowParser.class);
                    }
                    parser.initializeParser();
                    if (this.resource != null) {
                        CharSource source;
                        if (new File(this.resource).isFile()) {
                            this.logWriter.write("loading data from file '" + this.resource + "'");
                            source = Resources.asByteSource((URL)new File(this.resource).toURL()).asCharSource(Charset.forName(parser.getEncoding()));
                        } else if (loader.getResource(this.resource) != null) {
                            this.logWriter.write("loading data from resource '" + this.resource + "'");
                            source = Resources.asByteSource((URL)loader.getResource(this.resource)).asCharSource(Charset.forName(parser.getEncoding()));
                        } else {
                            this.logWriter.write("cannot find proper data from 'resource'.. regarding it as data string");
                            source = CharSource.wrap((CharSequence)this.resource);
                        }
                        this.readData(parser, source);
                    }
                    break block17;
                }
                throw new UOE("Unknown type[%s]", new Object[]{this.type});
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "INVALID JSON!", new Object[0]);
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private void registerModules(ObjectMapper jsonMapper, Iterable<DruidModule> fromExtensions) {
        for (DruidModule druidModule : fromExtensions) {
            for (com.fasterxml.jackson.databind.Module module : druidModule.getJacksonModules()) {
                jsonMapper.registerModule(module);
            }
        }
    }

    @VisibleForTesting
    void setLogWriter(Writer writer) {
        this.logWriter = writer;
    }

    private Void readData(final StringInputRowParser parser, CharSource source) throws IOException {
        return (Void)source.readLines((LineProcessor)new LineProcessor<Void>(){
            private final StringBuilder builder = new StringBuilder();

            public boolean processLine(String line) throws IOException {
                InputRow parsed = parser.parse(line);
                this.builder.append(parsed.getTimestamp());
                for (String dimension : parsed.getDimensions()) {
                    this.builder.append('\t');
                    this.builder.append(parsed.getRaw(dimension));
                }
                DruidJsonValidator.this.logWriter.write(this.builder.toString());
                this.builder.setLength(0);
                return true;
            }

            public Void getResult() {
                return null;
            }
        });
    }
}

