/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import io.druid.cli.RouterJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.curator.discovery.ServerDiscoveryFactory;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.discovery.DruidLeaderClient;
import io.druid.discovery.DruidNodeDiscoveryProvider;
import io.druid.discovery.DruidService;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.RouterProcessingModule;
import io.druid.guice.annotations.EscalatedGlobal;
import io.druid.guice.annotations.Self;
import io.druid.guice.http.JettyHttpClientModule;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.http.client.HttpClient;
import io.druid.query.lookup.LookupModule;
import io.druid.server.AsyncQueryForwardingServlet;
import io.druid.server.http.RouterResource;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.metrics.QueryCountStatsProvider;
import io.druid.server.router.AvaticaConnectionBalancer;
import io.druid.server.router.CoordinatorRuleManager;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerHostSelector;
import io.druid.server.router.TieredBrokerSelectorStrategiesProvider;
import io.druid.server.router.TieredBrokerSelectorStrategy;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="router", description="Experimental! Understands tiers and routes things to different brokers, see http://druid.io/docs/latest/development/router.html for a description")
public class CliRouter
extends ServerRunnable {
    private static final Logger log = new Logger(CliRouter.class);

    public CliRouter() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new RouterProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new JettyHttpClientModule("druid.router.http", Router.class), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/router");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8888);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(9088);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.router", TieredBrokerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.router.avatica.balancer", AvaticaConnectionBalancer.class);
                binder.bind(CoordinatorRuleManager.class);
                LifecycleModule.register((Binder)binder, CoordinatorRuleManager.class);
                binder.bind(TieredBrokerHostSelector.class).in(ManageLifecycle.class);
                binder.bind(QueryHostFinder.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<List<TieredBrokerSelectorStrategy>>(){}).toProvider(TieredBrokerSelectorStrategiesProvider.class).in(LazySingleton.class);
                binder.bind(QueryCountStatsProvider.class).to(AsyncQueryForwardingServlet.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(RouterJettyServerInitializer.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, RouterResource.class);
                LifecycleModule.register((Binder)binder, RouterResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                DiscoveryModule.register((Binder)binder, Self.class);
                binder.bind(ServerRunnable.DiscoverySideEffectsProvider.Child.class).toProvider((Provider)new ServerRunnable.DiscoverySideEffectsProvider("router", (List<Class<? extends DruidService>>)ImmutableList.of())).in(LazySingleton.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(ServerRunnable.DiscoverySideEffectsProvider.Child.class));
            }

            @Provides
            @ManageLifecycle
            public ServerDiscoverySelector getCoordinatorServerDiscoverySelector(TieredBrokerConfig config, ServerDiscoveryFactory factory) {
                return factory.createSelector(config.getCoordinatorServiceName());
            }

            @Provides
            @ManageLifecycle
            public DruidLeaderClient getLeaderHttpClient(@EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, ServerDiscoverySelector serverDiscoverySelector) {
                return new DruidLeaderClient(httpClient, druidNodeDiscoveryProvider, "coordinator", "/druid/coordinator/v1/leader", serverDiscoverySelector);
            }
        }, (Object)new LookupModule());
    }
}

