/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.cli.GuiceRunnable;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.annotations.Self;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnector;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.server.DruidNode;
import java.util.List;

@Command(name="metadata-init", description="Initialize Metadata Storage")
public class CreateTables
extends GuiceRunnable {
    @Option(name={"--connectURI"}, description="Database JDBC connection string", required=true)
    private String connectURI;
    @Option(name={"--user"}, description="Database username", required=true)
    private String user;
    @Option(name={"--password"}, description="Database password", required=true)
    private String password;
    @Option(name={"--base"}, description="Base table name")
    private String base;
    private static final Logger log = new Logger(CreateTables.class);

    public CreateTables() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageConnectorConfig.class), (Object)new MetadataStorageConnectorConfig(){

                    public String getConnectURI() {
                        return CreateTables.this.connectURI;
                    }

                    public String getUser() {
                        return CreateTables.this.user;
                    }

                    public String getPassword() {
                        return CreateTables.this.password;
                    }
                });
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageTablesConfig.class), (Object)MetadataStorageTablesConfig.fromBase((String)CreateTables.this.base));
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", Integer.valueOf(-1), null, true, false));
            }
        });
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        MetadataStorageConnector dbConnector = (MetadataStorageConnector)injector.getInstance(MetadataStorageConnector.class);
        dbConnector.createDataSourceTable();
        dbConnector.createPendingSegmentsTable();
        dbConnector.createSegmentTable();
        dbConnector.createRulesTable();
        dbConnector.createConfigTable();
        dbConnector.createTaskTables();
        dbConnector.createAuditTable();
        dbConnector.createSupervisorsTable();
    }
}

