/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.druid.initialization.Initialization;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.log.StartupLoggingConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Inject
    public void configure(Injector injector) {
        this.baseInjector = injector;
    }

    protected abstract List<? extends Module> getModules();

    public Injector makeInjector() {
        try {
            return Initialization.makeInjectorWithModules((Injector)this.baseInjector, this.getModules());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        try {
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            StartupLoggingConfig startupLoggingConfig = (StartupLoggingConfig)injector.getInstance(StartupLoggingConfig.class);
            this.log.info("Starting up with processors[%,d], memory[%,d], maxMemory[%,d].", new Object[]{Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory()});
            if (startupLoggingConfig.isLogProperties()) {
                HashSet maskProperties = Sets.newHashSet((Iterable)startupLoggingConfig.getMaskProperties());
                Properties props = (Properties)injector.getInstance(Properties.class);
                for (String propertyName : Ordering.natural().sortedCopy(props.stringPropertyNames())) {
                    String property = props.getProperty(propertyName);
                    for (String masked : maskProperties) {
                        if (!propertyName.contains(masked)) continue;
                        property = "<masked>";
                        break;
                    }
                    this.log.info("* %s: %s", new Object[]{propertyName, property});
                }
            }
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                this.log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

