/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthenticationUtils;
import io.druid.server.security.AuthenticatorMapper;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

class MiddleManagerJettyServerInitializer
implements JettyServerInitializer {
    private static Logger log = new Logger(MiddleManagerJettyServerInitializer.class);
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/status/health"});

    MiddleManagerJettyServerInitializer() {
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        List authenticators = null;
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root), new DefaultHandler()});
        server.setHandler((Handler)handlerList);
    }
}

