/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.initialization.ServerConfig;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.initialization.jetty.LimitRequestsFilter;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthenticationUtils;
import io.druid.server.security.AuthenticatorMapper;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class QueryJettyServerInitializer
implements JettyServerInitializer {
    private static final Logger log = new Logger(QueryJettyServerInitializer.class);
    private static List<String> UNSECURED_PATHS = Lists.newArrayList((Object[])new String[]{"/status/health"});
    private final List<Handler> extensionHandlers;
    private final ServerConfig serverConfig;

    @Inject
    public QueryJettyServerInitializer(Set<Handler> extensionHandlers, ServerConfig serverConfig) {
        this.extensionHandlers = ImmutableList.copyOf(extensionHandlers);
        this.serverConfig = serverConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        if (this.serverConfig.isEnableRequestLimit()) {
            Preconditions.checkArgument((this.serverConfig.getNumThreads() > 1 ? 1 : 0) != 0, (Object)"numThreads must be > 1 to enable Request Limit Filter.");
            log.info("Enabling Request Limit Filter with limit [%d].", new Object[]{this.serverConfig.getNumThreads() - 1});
            root.addFilter(new FilterHolder((Filter)new LimitRequestsFilter(this.serverConfig.getNumThreads() - 1)), "/*", null);
        }
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        List authenticators = null;
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/*", null);
        HandlerList handlerList = new HandlerList();
        Handler[] handlers = new Handler[this.extensionHandlers.size() + 2];
        handlers[0] = JettyServerInitUtils.getJettyRequestLogHandler();
        handlers[handlers.length - 1] = JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root);
        for (int i = 0; i < this.extensionHandlers.size(); ++i) {
            handlers[i + 1] = this.extensionHandlers.get(i);
        }
        handlerList.setHandlers(handlers);
        server.setHandler((Handler)handlerList);
    }
}

