/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import io.druid.cli.GuiceRunnable;
import io.druid.discovery.DiscoveryDruidNode;
import io.druid.discovery.DruidNodeAnnouncer;
import io.druid.discovery.DruidService;
import io.druid.guice.annotations.Self;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.DruidNode;
import java.util.List;
import java.util.Map;

public abstract class ServerRunnable
extends GuiceRunnable {
    public ServerRunnable(Logger log) {
        super(log);
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        Lifecycle lifecycle = this.initLifecycle(injector);
        try {
            lifecycle.join();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static class DiscoverySideEffectsProvider
    implements Provider<Child> {
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private DruidNodeAnnouncer announcer;
        @Inject
        private Lifecycle lifecycle;
        @Inject
        private Injector injector;
        private final String nodeType;
        private final List<Class<? extends DruidService>> serviceClasses;

        public DiscoverySideEffectsProvider(String nodeType, List<Class<? extends DruidService>> serviceClasses) {
            this.nodeType = nodeType;
            this.serviceClasses = serviceClasses;
        }

        public Child get() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Class<? extends DruidService> clazz : this.serviceClasses) {
                DruidService service = (DruidService)this.injector.getInstance(clazz);
                builder.put((Object)service.getName(), (Object)service);
            }
            final DiscoveryDruidNode discoveryDruidNode = new DiscoveryDruidNode(this.druidNode, this.nodeType, (Map)builder.build());
            this.lifecycle.addHandler(new Lifecycle.Handler(){

                public void start() throws Exception {
                    announcer.announce(discoveryDruidNode);
                }

                public void stop() {
                    announcer.unannounce(discoveryDruidNode);
                }
            }, Lifecycle.Stage.LAST);
            return new Child();
        }

        public static class Child {
        }
    }
}

