/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.util.Providers;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Command;
import io.druid.audit.AuditManager;
import io.druid.cli.ServerRunnable;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.IndexingServiceModuleHelper;
import io.druid.guice.IndexingServiceTaskLogsModule;
import io.druid.guice.JacksonConfigProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ListProvider;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.PolyBind;
import io.druid.indexing.common.actions.LocalTaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.tasklogs.SwitchingTaskLogStreamer;
import io.druid.indexing.common.tasklogs.TaskRunnerTaskLogStreamer;
import io.druid.indexing.overlord.ForkingTaskRunnerFactory;
import io.druid.indexing.overlord.HeapMemoryTaskStorage;
import io.druid.indexing.overlord.MetadataTaskStorage;
import io.druid.indexing.overlord.RemoteTaskRunnerFactory;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerResourceManagementConfig;
import io.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.SimpleWorkerResourceManagementConfig;
import io.druid.indexing.overlord.autoscaling.SimpleWorkerResourceManagementStrategy;
import io.druid.indexing.overlord.config.TaskQueueConfig;
import io.druid.indexing.overlord.http.OverlordRedirectInfo;
import io.druid.indexing.overlord.http.OverlordResource;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.indexing.overlord.supervisor.SupervisorResource;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.audit.AuditManagerProvider;
import io.druid.server.http.RedirectFilter;
import io.druid.server.http.RedirectInfo;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.tasklogs.TaskLogStreamer;
import io.druid.tasklogs.TaskLogs;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

@Command(name="overlord", description="Runs an Overlord node, see http://druid.io/docs/latest/Indexing-Service.html for a description")
public class CliOverlord
extends ServerRunnable {
    private static Logger log = new Logger(CliOverlord.class);

    public CliOverlord() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/overlord");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8090);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.queue", TaskQueueConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                binder.bind(TaskMaster.class).in(ManageLifecycle.class);
                binder.bind(TaskLogStreamer.class).to(SwitchingTaskLogStreamer.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<List<TaskLogStreamer>>(){}).toProvider((Provider)new ListProvider().add(TaskRunnerTaskLogStreamer.class).add(TaskLogs.class)).in(LazySingleton.class);
                binder.bind(TaskActionClientFactory.class).to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(TaskLockbox.class).in(LazySingleton.class);
                binder.bind(TaskStorageQueryAdapter.class).in(LazySingleton.class);
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of(null));
                this.configureTaskStorage(binder);
                this.configureAutoscale(binder);
                this.configureRunners(binder);
                binder.bind(AuditManager.class).toProvider(AuditManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                binder.bind(RedirectInfo.class).to(OverlordRedirectInfo.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).toInstance((Object)new OverlordJettyServerInitializer());
                Jerseys.addResource((Binder)binder, OverlordResource.class);
                Jerseys.addResource((Binder)binder, SupervisorResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }

            private void configureTaskStorage(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.storage.type", (Key)Key.get(TaskStorage.class), (Key)Key.get(HeapMemoryTaskStorage.class));
                MapBinder storageBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskStorage.class));
                storageBinder.addBinding((Object)"local").to(HeapMemoryTaskStorage.class);
                binder.bind(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                storageBinder.addBinding((Object)"metadata").to(MetadataTaskStorage.class).in(ManageLifecycle.class);
                binder.bind(MetadataTaskStorage.class).in(LazySingleton.class);
            }

            private void configureRunners(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.runner.type", (Key)Key.get(TaskRunnerFactory.class), (Key)Key.get(ForkingTaskRunnerFactory.class));
                MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskRunnerFactory.class));
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                biddy.addBinding((Object)"local").to(ForkingTaskRunnerFactory.class);
                binder.bind(ForkingTaskRunnerFactory.class).in(LazySingleton.class);
                biddy.addBinding((Object)"remote").to(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
                binder.bind(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
                JacksonConfigProvider.bind((Binder)binder, (String)"worker.config", WorkerBehaviorConfig.class, null);
            }

            private void configureAutoscale(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", ResourceManagementSchedulerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", PendingTaskBasedWorkerResourceManagementConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", SimpleWorkerResourceManagementConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.autoscale.strategy.type", (Key)Key.get(ResourceManagementStrategy.class), (Key)Key.get(SimpleWorkerResourceManagementStrategy.class));
                MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ResourceManagementStrategy.class));
                biddy.addBinding((Object)"simple").to(SimpleWorkerResourceManagementStrategy.class);
                biddy.addBinding((Object)"pendingTaskBased").to(PendingTaskBasedWorkerResourceManagementStrategy.class);
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceTaskLogsModule());
    }

    private static class OverlordJettyServerInitializer
    implements JettyServerInitializer {
        private OverlordJettyServerInitializer() {
        }

        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            root.setInitParameter("org.eclipse.jetty.servlet.Default.redirectWelcome", "true");
            root.setWelcomeFiles(new String[]{"index.html", "console.html"});
            ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
            root.addServlet(holderPwd, "/");
            root.setBaseResource((Resource)new ResourceCollection(new String[]{TaskMaster.class.getClassLoader().getResource("static").toExternalForm(), TaskMaster.class.getClassLoader().getResource("indexer_static").toExternalForm()}));
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            root.addFilter(JettyServerInitUtils.defaultGzipFilterHolder(), "/*", null);
            root.addFilter(GuiceFilter.class, "/status/*", null);
            root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
            root.addFilter(GuiceFilter.class, "/druid/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), root});
            server.setHandler((Handler)handlerList);
        }
    }
}

