/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Command;
import io.druid.cli.CliBroker;
import io.druid.cli.ServerRunnable;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.client.ServerView;
import io.druid.guice.LazySingleton;
import io.druid.guice.RealtimeModule;
import io.druid.query.lookup.LookupModule;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.initialization.jetty.ChatHandlerServerModule;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;

@Command(name="realtime", description="Runs a standalone realtime node for examples, see http://druid.io/docs/latest/Realtime.html for a description")
public class CliRealtimeExample
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);
    @Inject
    private Properties properties;

    public CliRealtimeExample() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new RealtimeModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/realtime");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8084);
                binder.bind(DataSegmentPusher.class).to(NoopDataSegmentPusher.class).in(LazySingleton.class);
                binder.bind(DataSegmentAnnouncer.class).to(NoopDataSegmentAnnouncer.class).in(LazySingleton.class);
                binder.bind(InventoryView.class).to(NoopInventoryView.class).in(LazySingleton.class);
                binder.bind(ServerView.class).to(NoopServerView.class).in(LazySingleton.class);
            }
        }, (Object)new ChatHandlerServerModule(this.properties), (Object)new LookupModule());
    }

    private static class NoopDataSegmentAnnouncer
    implements DataSegmentAnnouncer {
        private NoopDataSegmentAnnouncer() {
        }

        public void announceSegment(DataSegment segment) throws IOException {
        }

        public void unannounceSegment(DataSegment segment) throws IOException {
        }

        public void announceSegments(Iterable<DataSegment> segments) throws IOException {
        }

        public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
        }

        public boolean isAnnounced(DataSegment segment) {
            return false;
        }
    }

    private static class NoopDataSegmentPusher
    implements DataSegmentPusher {
        private NoopDataSegmentPusher() {
        }

        public String getPathForHadoop(String dataSource) {
            return dataSource;
        }

        public DataSegment push(File file, DataSegment segment) throws IOException {
            return segment;
        }
    }

    private static class NoopInventoryView
    implements InventoryView {
        private NoopInventoryView() {
        }

        public DruidServer getInventoryValue(String string) {
            return null;
        }

        public Iterable<DruidServer> getInventory() {
            return ImmutableList.of();
        }
    }

    private static class NoopServerView
    implements ServerView {
        private NoopServerView() {
        }

        public void registerServerCallback(Executor exec, ServerView.ServerCallback callback) {
        }

        public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        }
    }
}

