/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Command;
import io.druid.audit.AuditManager;
import io.druid.cli.CoordinatorJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.client.CoordinatorServerView;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.guice.ConditionalMultibind;
import io.druid.guice.ConfigProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import io.druid.metadata.MetadataRuleManager;
import io.druid.metadata.MetadataRuleManagerConfig;
import io.druid.metadata.MetadataRuleManagerProvider;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.metadata.MetadataSegmentManagerConfig;
import io.druid.metadata.MetadataSegmentManagerProvider;
import io.druid.metadata.MetadataStorage;
import io.druid.metadata.MetadataStorageProvider;
import io.druid.server.audit.AuditManagerProvider;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.LoadQueueTaskMaster;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentKiller;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentMerger;
import io.druid.server.coordinator.helper.DruidCoordinatorVersionConverter;
import io.druid.server.http.CoordinatorDynamicConfigsResource;
import io.druid.server.http.CoordinatorRedirectInfo;
import io.druid.server.http.CoordinatorResource;
import io.druid.server.http.DatasourcesResource;
import io.druid.server.http.IntervalsResource;
import io.druid.server.http.LookupCoordinatorResource;
import io.druid.server.http.MetadataResource;
import io.druid.server.http.RedirectFilter;
import io.druid.server.http.RedirectInfo;
import io.druid.server.http.RulesResource;
import io.druid.server.http.ServersResource;
import io.druid.server.http.TiersResource;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.listener.announcer.ListenerDiscoverer;
import io.druid.server.lookup.cache.LookupCoordinatorManager;
import io.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jetty.server.Server;

@Command(name="coordinator", description="Runs the Coordinator, see http://druid.io/docs/latest/Coordinator.html for a description.")
public class CliCoordinator
extends ServerRunnable {
    private static final Logger log = new Logger(CliCoordinator.class);
    private Properties properties;

    public CliCoordinator() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/coordinator");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8081);
                ConfigProvider.bind((Binder)binder, DruidCoordinatorConfig.class);
                binder.bind(MetadataStorage.class).toProvider(MetadataStorageProvider.class).in(ManageLifecycle.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", MetadataSegmentManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", MetadataRuleManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.lookups", LookupCoordinatorManagerConfig.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                binder.bind(RedirectInfo.class).to(CoordinatorRedirectInfo.class).in(LazySingleton.class);
                binder.bind(MetadataSegmentManager.class).toProvider(MetadataSegmentManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(MetadataRuleManager.class).toProvider(MetadataRuleManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(AuditManager.class).toProvider(AuditManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(IndexingServiceClient.class).in(LazySingleton.class);
                binder.bind(CoordinatorServerView.class).in(LazySingleton.class);
                binder.bind(DruidCoordinator.class);
                binder.bind(LookupCoordinatorManager.class).in(ManageLifecycle.class);
                binder.bind(ListenerDiscoverer.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, ListenerDiscoverer.class);
                LifecycleModule.register((Binder)binder, MetadataStorage.class);
                LifecycleModule.register((Binder)binder, DruidCoordinator.class);
                LifecycleModule.register((Binder)binder, LookupCoordinatorManager.class);
                binder.bind(JettyServerInitializer.class).to(CoordinatorJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, CoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorDynamicConfigsResource.class);
                Jerseys.addResource((Binder)binder, TiersResource.class);
                Jerseys.addResource((Binder)binder, RulesResource.class);
                Jerseys.addResource((Binder)binder, ServersResource.class);
                Jerseys.addResource((Binder)binder, DatasourcesResource.class);
                Jerseys.addResource((Binder)binder, MetadataResource.class);
                Jerseys.addResource((Binder)binder, IntervalsResource.class);
                Jerseys.addResource((Binder)binder, LookupCoordinatorResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                LifecycleModule.register((Binder)binder, DatasourcesResource.class);
                ConditionalMultibind.create((Properties)CliCoordinator.this.properties, (Binder)binder, DruidCoordinatorHelper.class, CoordinatorIndexingServiceHelper.class).addConditionBinding("druid.coordinator.merge.on", Predicates.equalTo((Object)"true"), DruidCoordinatorSegmentMerger.class).addConditionBinding("druid.coordinator.conversion.on", Predicates.equalTo((Object)"true"), DruidCoordinatorVersionConverter.class).addConditionBinding("druid.coordinator.kill.on", Predicates.equalTo((Object)"true"), DruidCoordinatorSegmentKiller.class);
            }

            @Provides
            @LazySingleton
            public LoadQueueTaskMaster getLoadQueueTaskMaster(CuratorFramework curator, ObjectMapper jsonMapper, ScheduledExecutorFactory factory, DruidCoordinatorConfig config) {
                return new LoadQueueTaskMaster(curator, jsonMapper, factory.create(1, "Master-PeonExec--%d"), Executors.newSingleThreadExecutor(), config);
            }
        });
    }
}

