/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.druid.cli.CliHadoopIndexer;
import io.druid.cli.GuiceRunnable;
import io.druid.guice.LazySingleton;
import io.druid.indexer.HadoopDruidDetermineConfigurationJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerJob;
import io.druid.indexer.HadoopIngestionSpec;
import io.druid.indexer.JobHelper;
import io.druid.indexer.MetadataStorageUpdaterJobHandler;
import io.druid.indexer.path.MetadataStoreBasedUsedSegmentLister;
import io.druid.indexer.path.UsedSegmentLister;
import io.druid.indexer.updater.MetadataStorageUpdaterJobSpec;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@Command(name="hadoop-indexer", description="Runs the batch Hadoop Druid Indexer, see http://druid.io/docs/latest/Batch-ingestion.html for a description.")
public class CliInternalHadoopIndexer
extends GuiceRunnable {
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object", required=true)
    private String argumentSpec;
    private HadoopDruidIndexerConfig config;

    public CliInternalHadoopIndexer() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/internal-hadoop-indexer");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                MetadataStorageUpdaterJobSpec metadataSpec = CliInternalHadoopIndexer.this.getHadoopDruidIndexerConfig().getSchema().getIOConfig().getMetadataUpdateSpec();
                binder.bind((TypeLiteral)new TypeLiteral<Supplier<MetadataStorageConnectorConfig>>(){}).toInstance((Object)metadataSpec);
                binder.bind(MetadataStorageTablesConfig.class).toInstance((Object)metadataSpec.getMetadataStorageTablesConfig());
                binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(LazySingleton.class);
            }
        });
    }

    @Override
    public void run() {
        try {
            Injector injector = this.makeInjector();
            this.config = this.getHadoopDruidIndexerConfig();
            MetadataStorageUpdaterJobSpec metadataSpec = this.config.getSchema().getIOConfig().getMetadataUpdateSpec();
            Preconditions.checkNotNull((Object)metadataSpec.getType(), (Object)"type in metadataUpdateSpec must not be null");
            ((Properties)injector.getInstance(Properties.class)).setProperty("druid.metadata.storage.type", metadataSpec.getType());
            this.config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)HadoopIngestionSpec.updateSegmentListIfDatasourcePathSpecIsUsed((HadoopIngestionSpec)this.config.getSchema(), (ObjectMapper)HadoopDruidIndexerConfig.JSON_MAPPER, (UsedSegmentLister)new MetadataStoreBasedUsedSegmentLister((IndexerMetadataStorageCoordinator)injector.getInstance(IndexerMetadataStorageCoordinator.class))));
            ArrayList jobs = Lists.newArrayList();
            jobs.add(new HadoopDruidDetermineConfigurationJob(this.config));
            jobs.add(new HadoopDruidIndexerJob(this.config, (MetadataStorageUpdaterJobHandler)injector.getInstance(MetadataStorageUpdaterJobHandler.class)));
            JobHelper.runJobs((List)jobs, (HadoopDruidIndexerConfig)this.config);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HadoopDruidIndexerConfig getHadoopDruidIndexerConfig() {
        block7: {
            if (this.config == null) {
                try {
                    if (this.argumentSpec.startsWith("{")) {
                        this.config = HadoopDruidIndexerConfig.fromString((String)this.argumentSpec);
                        break block7;
                    }
                    File localConfigFile = null;
                    try {
                        URI argumentSpecUri = new URI(this.argumentSpec);
                        String argumentSpecScheme = argumentSpecUri.getScheme();
                        if (argumentSpecScheme == null || argumentSpecScheme.equals("file")) {
                            localConfigFile = new File(argumentSpecUri.getPath());
                        }
                    }
                    catch (URISyntaxException e) {
                        localConfigFile = new File(this.argumentSpec);
                    }
                    this.config = localConfigFile != null ? HadoopDruidIndexerConfig.fromFile((File)localConfigFile) : HadoopDruidIndexerConfig.fromDistributedFileSystem((String)this.argumentSpec);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return this.config;
    }
}

