/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.http.OverlordProxyServlet;
import io.druid.server.http.RedirectFilter;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

class CoordinatorJettyServerInitializer
implements JettyServerInitializer {
    private final DruidCoordinatorConfig config;

    @Inject
    CoordinatorJettyServerInitializer(DruidCoordinatorConfig config) {
        this.config = config;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        root.addServlet(holderPwd, "/");
        if (this.config.getConsoleStatic() == null) {
            ResourceCollection staticResources = new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"io/druid/console"), Resource.newClassPathResource((String)"static")});
            root.setBaseResource((Resource)staticResources);
        } else {
            root.setResourceBase(this.config.getConsoleStatic());
        }
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        root.addFilter(JettyServerInitUtils.defaultGzipFilterHolder(), "/*", null);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
        root.addFilter(GuiceFilter.class, "/info/*", null);
        root.addFilter(GuiceFilter.class, "/druid/coordinator/*", null);
        root.addFilter(GuiceFilter.class, "/coordinator/*", null);
        root.addServlet(new ServletHolder((Servlet)injector.getInstance(OverlordProxyServlet.class)), "/druid/indexer/*");
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), root});
        server.setHandler((Handler)handlerList);
    }
}

