/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.inject.Injector;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseException;
import io.druid.cli.CliBroker;
import io.druid.cli.CliCommandCreator;
import io.druid.cli.CliCoordinator;
import io.druid.cli.CliHadoopIndexer;
import io.druid.cli.CliHistorical;
import io.druid.cli.CliInternalHadoopIndexer;
import io.druid.cli.CliMiddleManager;
import io.druid.cli.CliOverlord;
import io.druid.cli.CliPeon;
import io.druid.cli.CliRealtime;
import io.druid.cli.CliRealtimeExample;
import io.druid.cli.CliRouter;
import io.druid.cli.CreateTables;
import io.druid.cli.DumpSegment;
import io.druid.cli.InsertSegment;
import io.druid.cli.PropertyChecker;
import io.druid.cli.PullDependencies;
import io.druid.cli.Version;
import io.druid.cli.validate.DruidJsonValidator;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.GuiceInjectors;
import io.druid.initialization.Initialization;
import java.util.Collection;
import java.util.ServiceLoader;

public class Main {
    public static void main(String[] args) {
        Cli.CliBuilder builder = Cli.builder((String)"druid");
        builder.withDescription("Druid command-line runner.").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Version.class});
        builder.withGroup("server").withDescription("Run one of the Druid server types.").withDefaultCommand(Help.class).withCommands(CliCoordinator.class, new Class[]{CliHistorical.class, CliBroker.class, CliRealtime.class, CliOverlord.class, CliMiddleManager.class, CliRouter.class});
        builder.withGroup("example").withDescription("Run an example").withDefaultCommand(Help.class).withCommands(CliRealtimeExample.class, new Class[0]);
        builder.withGroup("tools").withDescription("Various tools for working with Druid").withDefaultCommand(Help.class).withCommands(DruidJsonValidator.class, new Class[]{PullDependencies.class, CreateTables.class, InsertSegment.class, DumpSegment.class});
        builder.withGroup("index").withDescription("Run indexing for druid").withDefaultCommand(Help.class).withCommands(CliHadoopIndexer.class, new Class[0]);
        builder.withGroup("internal").withDescription("Processes that Druid runs \"internally\", you should rarely use these directly").withDefaultCommand(Help.class).withCommands(CliPeon.class, new Class[]{CliInternalHadoopIndexer.class});
        Injector injector = GuiceInjectors.makeStartupInjector();
        ExtensionsConfig config = (ExtensionsConfig)injector.getInstance(ExtensionsConfig.class);
        Collection extensionCommands = Initialization.getFromExtensions((ExtensionsConfig)config, CliCommandCreator.class);
        for (CliCommandCreator creator : extensionCommands) {
            creator.addCommands(builder);
        }
        Cli cli = builder.build();
        try {
            Runnable command = (Runnable)cli.parse(args);
            if (!(command instanceof Help)) {
                injector.injectMembers((Object)command);
            }
            command.run();
        }
        catch (ParseException e) {
            System.out.println("ERROR!!!!");
            System.out.println(e.getMessage());
            System.out.println("===");
            ((Runnable)cli.parse(new String[]{"help"})).run();
            System.exit(1);
        }
    }

    static {
        ServiceLoader<PropertyChecker> serviceLoader = ServiceLoader.load(PropertyChecker.class);
        for (PropertyChecker propertyChecker : serviceLoader) {
            propertyChecker.checkProperties(System.getProperties());
        }
    }
}

