/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.avatica;

import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.java.util.metrics.AbstractMonitor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.calcite.avatica.metrics.Counter;
import org.apache.calcite.avatica.metrics.Gauge;
import org.apache.calcite.avatica.metrics.Histogram;
import org.apache.calcite.avatica.metrics.Meter;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.Timer;

public class AvaticaMonitor
extends AbstractMonitor
implements MetricsSystem {
    private static final Logger log = new Logger(AvaticaMonitor.class);
    private final ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, Gauge<?>> gauges = new ConcurrentHashMap();

    public boolean doMonitor(ServiceEmitter emitter) {
        String name;
        for (Map.Entry entry : this.counters.entrySet()) {
            name = (String)entry.getKey();
            long value = ((AtomicLong)entry.getValue()).getAndSet(0L);
            emitter.emit(ServiceMetricEvent.builder().build(this.fullMetricName(name), (Number)value));
        }
        for (Map.Entry entry : this.gauges.entrySet()) {
            name = (String)entry.getKey();
            Object value = ((Gauge)entry.getValue()).getValue();
            if (value instanceof Number) {
                emitter.emit(ServiceMetricEvent.builder().build(this.fullMetricName(name), (Number)value));
                continue;
            }
            log.debug("Not emitting gauge[%s] since value[%s] type was[%s].", new Object[]{name, value, value.getClass().getName()});
        }
        return true;
    }

    public Timer getTimer(String name) {
        final AtomicLong counter = this.makeCounter(name);
        return new Timer(){

            public Timer.Context start() {
                final long start = System.currentTimeMillis();
                final AtomicBoolean closed = new AtomicBoolean();
                return new Timer.Context(){

                    public void close() {
                        if (closed.compareAndSet(false, true)) {
                            counter.addAndGet(System.currentTimeMillis() - start);
                        }
                    }
                };
            }
        };
    }

    public Histogram getHistogram(String name) {
        return new Histogram(){

            public void update(int i) {
            }

            public void update(long l) {
            }
        };
    }

    public Meter getMeter(String name) {
        final AtomicLong counter = this.makeCounter(name);
        return new Meter(){

            public void mark() {
                counter.incrementAndGet();
            }

            public void mark(long events) {
                counter.addAndGet(events);
            }
        };
    }

    public Counter getCounter(String name) {
        final AtomicLong counter = this.makeCounter(name);
        return new Counter(){

            public void increment() {
                counter.incrementAndGet();
            }

            public void increment(long n) {
                counter.addAndGet(n);
            }

            public void decrement() {
                counter.decrementAndGet();
            }

            public void decrement(long n) {
                counter.addAndGet(-n);
            }
        };
    }

    public <T> void register(String name, Gauge<T> gauge) {
        if (this.gauges.putIfAbsent(name, gauge) != null) {
            log.warn("Ignoring gauge[%s], one with the same name was already registered.", new Object[]{name});
        }
    }

    private AtomicLong makeCounter(String name) {
        this.counters.putIfAbsent(name, new AtomicLong());
        return (AtomicLong)this.counters.get(name);
    }

    private String fullMetricName(String name) {
        return name.replace("org.apache.calcite.avatica", "avatica").replace(".", "/");
    }
}

