/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.sql.avatica.DruidStatement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DruidConnection {
    private static final Logger log = new Logger(DruidConnection.class);
    private static final Set<String> SENSITIVE_CONTEXT_FIELDS = Sets.newHashSet((Object[])new String[]{"user", "password"});
    private final String connectionId;
    private final int maxStatements;
    private final ImmutableMap<String, Object> context;
    private final AtomicInteger statementCounter = new AtomicInteger();
    private final AtomicReference<Future<?>> timeoutFuture = new AtomicReference();
    @GuardedBy(value="statements")
    private final Map<Integer, DruidStatement> statements;
    @GuardedBy(value="statements")
    private boolean open = true;

    public DruidConnection(String connectionId, int maxStatements, Map<String, Object> context) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId);
        this.maxStatements = maxStatements;
        this.context = ImmutableMap.copyOf(context);
        this.statements = new HashMap<Integer, DruidStatement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement createStatement() {
        int statementId = this.statementCounter.incrementAndGet();
        Map<Integer, DruidStatement> map = this.statements;
        synchronized (map) {
            if (this.statements.containsKey(statementId)) {
                throw new ISE("Uh oh, too many statements", new Object[0]);
            }
            if (this.statements.size() >= this.maxStatements) {
                throw new ISE("Too many open statements, limit is[%,d]", new Object[]{this.maxStatements});
            }
            Map sanitizedContext = Maps.newHashMap();
            sanitizedContext = Maps.filterEntries(this.context, (Predicate)new Predicate<Map.Entry<String, Object>>(){

                public boolean apply(@Nullable Map.Entry<String, Object> input) {
                    return !SENSITIVE_CONTEXT_FIELDS.contains(input.getKey());
                }
            });
            DruidStatement statement = new DruidStatement(this.connectionId, statementId, (Map<String, Object>)ImmutableSortedMap.copyOf((Map)sanitizedContext), () -> {
                Map<Integer, DruidStatement> map = this.statements;
                synchronized (map) {
                    log.debug("Connection[%s] closed statement[%s].", new Object[]{this.connectionId, statementId});
                    this.statements.remove(statementId);
                }
            });
            this.statements.put(statementId, statement);
            log.debug("Connection[%s] opened statement[%s].", new Object[]{this.connectionId, statementId});
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement getStatement(int statementId) {
        Map<Integer, DruidStatement> map = this.statements;
        synchronized (map) {
            return this.statements.get(statementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIfEmpty() {
        Map<Integer, DruidStatement> map = this.statements;
        synchronized (map) {
            if (this.statements.isEmpty()) {
                this.close();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<Integer, DruidStatement> map = this.statements;
        synchronized (map) {
            for (DruidStatement statement : ImmutableList.copyOf(this.statements.values())) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn("Connection[%s] failed to close statement[%s]!", new Object[]{this.connectionId, statement.getStatementId()});
                }
            }
            log.debug("Connection[%s] closed.", new Object[]{this.connectionId});
            this.open = false;
        }
    }

    public DruidConnection sync(Future<?> newTimeoutFuture) {
        Future<?> oldFuture = this.timeoutFuture.getAndSet(newTimeoutFuture);
        if (oldFuture != null) {
            oldFuture.cancel(false);
        }
        return this;
    }

    public Map<String, Object> context() {
        return this.context;
    }
}

