/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.segment.VirtualColumn;
import io.druid.sql.calcite.filtration.Filtration;
import io.druid.sql.calcite.table.RowSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class Aggregation {
    private final List<VirtualColumn> virtualColumns;
    private final List<AggregatorFactory> aggregatorFactories;
    private final PostAggregator postAggregator;

    private Aggregation(List<VirtualColumn> virtualColumns, List<AggregatorFactory> aggregatorFactories, PostAggregator postAggregator) {
        this.virtualColumns = (List)Preconditions.checkNotNull(virtualColumns, (Object)"virtualColumns");
        this.aggregatorFactories = (List)Preconditions.checkNotNull(aggregatorFactories, (Object)"aggregatorFactories");
        this.postAggregator = postAggregator;
        if (aggregatorFactories.isEmpty()) {
            Preconditions.checkArgument((postAggregator != null ? 1 : 0) != 0, (Object)"postAggregator must be present if there are no aggregators");
        }
        if (postAggregator == null) {
            Preconditions.checkArgument((aggregatorFactories.size() == 1 ? 1 : 0) != 0, (Object)"aggregatorFactories.size == 1");
        } else {
            Set dependentFields = postAggregator.getDependentFields();
            for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
                if (dependentFields.contains(aggregatorFactory.getName())) continue;
                throw new IAE("Unused field[%s] in Aggregation", new Object[]{aggregatorFactory.getName()});
            }
        }
        String name = postAggregator != null ? postAggregator.getName() : ((AggregatorFactory)Iterables.getOnlyElement(aggregatorFactories)).getName();
        for (VirtualColumn virtualColumn : virtualColumns) {
            if (virtualColumn.getOutputName().startsWith(name)) continue;
            throw new IAE("VirtualColumn[%s] not prefixed under[%s]", new Object[]{virtualColumn.getOutputName(), name});
        }
        for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
            if (aggregatorFactory.getName().startsWith(name)) continue;
            throw new IAE("Aggregator[%s] not prefixed under[%s]", new Object[]{aggregatorFactory.getName(), name});
        }
    }

    public static Aggregation create(List<VirtualColumn> virtualColumns, AggregatorFactory aggregatorFactory) {
        return new Aggregation(virtualColumns, (List<AggregatorFactory>)ImmutableList.of((Object)aggregatorFactory), null);
    }

    public static Aggregation create(AggregatorFactory aggregatorFactory) {
        return new Aggregation((List<VirtualColumn>)ImmutableList.of(), (List<AggregatorFactory>)ImmutableList.of((Object)aggregatorFactory), null);
    }

    public static Aggregation create(PostAggregator postAggregator) {
        return new Aggregation(Collections.emptyList(), Collections.emptyList(), postAggregator);
    }

    public static Aggregation create(List<AggregatorFactory> aggregatorFactories, PostAggregator postAggregator) {
        return new Aggregation((List<VirtualColumn>)ImmutableList.of(), aggregatorFactories, postAggregator);
    }

    public static Aggregation create(List<VirtualColumn> virtualColumns, List<AggregatorFactory> aggregatorFactories, PostAggregator postAggregator) {
        return new Aggregation(virtualColumns, aggregatorFactories, postAggregator);
    }

    public List<VirtualColumn> getVirtualColumns() {
        return this.virtualColumns;
    }

    public List<AggregatorFactory> getAggregatorFactories() {
        return this.aggregatorFactories;
    }

    @Nullable
    public PostAggregator getPostAggregator() {
        return this.postAggregator;
    }

    public String getOutputName() {
        return this.postAggregator != null ? this.postAggregator.getName() : ((AggregatorFactory)Iterables.getOnlyElement(this.aggregatorFactories)).getName();
    }

    public Aggregation filter(RowSignature sourceRowSignature, DimFilter filter) {
        if (filter == null) {
            return this;
        }
        if (this.postAggregator != null) {
            Set dependentFields = this.postAggregator.getDependentFields();
            HashSet aggregatorNames = Sets.newHashSet();
            for (AggregatorFactory aggregatorFactory : this.aggregatorFactories) {
                aggregatorNames.add(aggregatorFactory.getName());
            }
            for (String field : dependentFields) {
                if (aggregatorNames.contains(field)) continue;
                throw new ISE("Cannot filter an Aggregation that does not contain its inputs: %s", new Object[]{this});
            }
        }
        DimFilter baseOptimizedFilter = Filtration.create(filter).optimizeFilterOnly(sourceRowSignature).getDimFilter();
        ArrayList newAggregators = Lists.newArrayList();
        for (AggregatorFactory agg : this.aggregatorFactories) {
            if (agg instanceof FilteredAggregatorFactory) {
                FilteredAggregatorFactory filteredAgg = (FilteredAggregatorFactory)agg;
                newAggregators.add(new FilteredAggregatorFactory(filteredAgg.getAggregator(), Filtration.create((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)filteredAgg.getFilter(), (Object)baseOptimizedFilter))).optimizeFilterOnly(sourceRowSignature).getDimFilter()));
                continue;
            }
            newAggregators.add(new FilteredAggregatorFactory(agg, baseOptimizedFilter));
        }
        return new Aggregation(this.virtualColumns, newAggregators, this.postAggregator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggregation that = (Aggregation)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.aggregatorFactories, that.aggregatorFactories) && Objects.equals(this.postAggregator, that.postAggregator);
    }

    public int hashCode() {
        return Objects.hash(this.virtualColumns, this.aggregatorFactories, this.postAggregator);
    }

    public String toString() {
        return "Aggregation{virtualColumns=" + this.virtualColumns + ", aggregatorFactories=" + this.aggregatorFactories + ", postAggregator=" + this.postAggregator + '}';
    }
}

