/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.aggregation;

import io.druid.segment.column.ValueType;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;

public class Aggregations {
    private Aggregations() {
    }

    @Nullable
    public static List<DruidExpression> getArgumentsForSimpleAggregator(PlannerContext plannerContext, RowSignature rowSignature, AggregateCall call, Project project) {
        return call.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).map(rexNode -> Aggregations.toDruidExpressionForSimpleAggregator(plannerContext, rowSignature, rexNode)).collect(Collectors.toList());
    }

    private static DruidExpression toDruidExpressionForSimpleAggregator(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        if (druidExpression == null) {
            return null;
        }
        if (druidExpression.isSimpleExtraction() && (!druidExpression.isDirectColumnAccess() || rowSignature.getColumnType(druidExpression.getDirectColumn()) == ValueType.STRING)) {
            return druidExpression.map(simpleExtraction -> null, Function.identity());
        }
        return druidExpression;
    }
}

