/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.segment.column.ValueType;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.Aggregations;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.SumSqlAggregator;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class AvgSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.AVG;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String expression;
        String fieldName;
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (arguments == null) {
            return null;
        }
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ValueType sumType = SqlTypeName.INT_TYPES.contains(aggregateCall.getType().getSqlTypeName()) ? ValueType.LONG : ValueType.DOUBLE;
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        if (arg.isDirectColumnAccess()) {
            fieldName = arg.getDirectColumn();
            expression = null;
        } else {
            fieldName = null;
            expression = arg.getExpression();
        }
        String sumName = Calcites.makePrefixedName(name, "sum");
        String countName = Calcites.makePrefixedName(name, "count");
        AggregatorFactory sum = SumSqlAggregator.createSumAggregatorFactory(sumType, sumName, fieldName, expression, macroTable);
        CountAggregatorFactory count = new CountAggregatorFactory(countName);
        return Aggregation.create((List<AggregatorFactory>)ImmutableList.of((Object)sum, (Object)count), (PostAggregator)new ArithmeticPostAggregator(name, "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, sumName), (Object)new FieldAccessPostAggregator(null, countName))));
    }
}

