/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.druid.java.util.common.ISE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.filter.DimFilter;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.Aggregations;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.aggregation.builtin.ApproxCountDistinctSqlAggregator;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.expression.Expressions;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class CountSqlAggregator
implements SqlAggregator {
    private static final ApproxCountDistinctSqlAggregator APPROX_COUNT_DISTINCT = new ApproxCountDistinctSqlAggregator();

    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.COUNT;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        List<DruidExpression> args = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (args == null) {
            return null;
        }
        if (args.isEmpty()) {
            return Aggregation.create((AggregatorFactory)new CountAggregatorFactory(name));
        }
        if (aggregateCall.isDistinct()) {
            if (plannerContext.getPlannerConfig().isUseApproximateCountDistinct()) {
                return APPROX_COUNT_DISTINCT.toDruidAggregation(plannerContext, rowSignature, rexBuilder, name, aggregateCall, project, existingAggregations, finalizeAggregations);
            }
            return null;
        }
        RexNode rexNode = Expressions.fromFieldAccess(rowSignature, project, (Integer)Iterables.getOnlyElement((Iterable)aggregateCall.getArgList()));
        if (rexNode.getType().isNullable()) {
            DimFilter nonNullFilter = Expressions.toFilter(plannerContext, rowSignature, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (List)ImmutableList.of((Object)rexNode)));
            if (nonNullFilter == null) {
                throw new ISE("Could not create not-null filter for rexNode[%s]", new Object[]{rexNode});
            }
            return Aggregation.create((AggregatorFactory)new CountAggregatorFactory(name)).filter(rowSignature, nonNullFilter);
        }
        return Aggregation.create((AggregatorFactory)new CountAggregatorFactory(name));
    }
}

