/*
 * Decompiled with CFR 0.152.
 */
package io.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.Iterables;
import io.druid.java.util.common.ISE;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.FloatSumAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.segment.column.ValueType;
import io.druid.sql.calcite.aggregation.Aggregation;
import io.druid.sql.calcite.aggregation.Aggregations;
import io.druid.sql.calcite.aggregation.SqlAggregator;
import io.druid.sql.calcite.expression.DruidExpression;
import io.druid.sql.calcite.planner.Calcites;
import io.druid.sql.calcite.planner.PlannerContext;
import io.druid.sql.calcite.table.RowSignature;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class SumSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.SUM;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String expression;
        String fieldName;
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (arguments == null) {
            return null;
        }
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ValueType valueType = Calcites.getValueTypeForSqlTypeName(aggregateCall.getType().getSqlTypeName());
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        if (arg.isDirectColumnAccess()) {
            fieldName = arg.getDirectColumn();
            expression = null;
        } else {
            fieldName = null;
            expression = arg.getExpression();
        }
        return Aggregation.create(SumSqlAggregator.createSumAggregatorFactory(valueType, name, fieldName, expression, macroTable));
    }

    static AggregatorFactory createSumAggregatorFactory(ValueType aggregationType, String name, String fieldName, String expression, ExprMacroTable macroTable) {
        switch (aggregationType) {
            case LONG: {
                return new LongSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case FLOAT: {
                return new FloatSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case DOUBLE: {
                return new DoubleSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
        }
        throw new ISE("Cannot create aggregator factory for type[%s]", new Object[]{aggregationType});
    }
}

